/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.IBox;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;

public abstract class FillerPattern
implements IFillerPattern {
    protected int id;

    @Override
    public abstract boolean iteratePattern(any var1, IBox var2, ur var3);

    @Override
    public abstract String getTextureFile();

    @Override
    public abstract int getTextureIndex();

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean fill(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, ur stackToPlace, yc world) {
        boolean found = false;
        int xSlot = 0;
        int ySlot = 0;
        int zSlot = 0;
        for (int y2 = yMin; y2 <= yMax && !found; ++y2) {
            for (int x = xMin; x <= xMax && !found; ++x) {
                for (int z = zMin; z <= zMax && !found; ++z) {
                    if (!BlockUtil.canChangeBlock(world, x, y2, z)) {
                        return false;
                    }
                    if (!BlockUtil.isSoftBlock(world, x, y2, z)) continue;
                    xSlot = x;
                    ySlot = y2;
                    zSlot = z;
                    found = true;
                }
            }
        }
        if (found && stackToPlace != null) {
            stackToPlace.b().a(stackToPlace, CoreProxy.proxy.getBuildCraftPlayer(world), world, xSlot, ySlot - 1, zSlot, 1, 0.0f, 0.0f, 0.0f);
        }
        return found;
    }

    public boolean empty(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, yc world) {
        boolean found = false;
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (int y2 = yMax; y2 >= yMin; --y2) {
            found = false;
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!BlockUtil.canChangeBlock(world, x, y2, z)) {
                        return false;
                    }
                    if (BlockUtil.isSoftBlock(world, x, y2, z)) continue;
                    found = true;
                    lastX = x;
                    lastY = y2;
                    lastZ = z;
                }
            }
            if (found) break;
        }
        if (lastX != Integer.MAX_VALUE) {
            if (BuildCraftBuilders.fillerDestroy) {
                world.e(lastX, lastY, lastZ, 0);
            } else {
                BlockUtil.breakBlock(world, lastX, lastY, lastZ, 20);
            }
            return true;
        }
        return false;
    }
}

