/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import java.util.Random;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class OilPopulate {
    @ForgeSubscribe
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((zw)event.chunkProvider, (yc)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkX, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        if (!doGen) {
            return;
        }
        int worldX = event.chunkX << 4;
        int worldZ = event.chunkZ << 4;
        OilPopulate.doPopulate(event.world, event.rand, worldX, worldZ);
    }

    public static void doPopulate(yc world, Random rand, int x, int z) {
        boolean largeDeposit;
        yy biomegenbase = world.a(x + 16, z + 16);
        if (biomegenbase.N == yy.k.N || biomegenbase.N == yy.j.N) {
            return;
        }
        if (biomegenbase == yy.d && (double)rand.nextFloat() > 0.97) {
            int startX = rand.nextInt(10) + 2;
            int startZ = rand.nextInt(10) + 2;
            for (int j = 128; j > 65; --j) {
                int i = startX + x;
                int k = startZ + z;
                if (world.a(i, j, k) == 0) continue;
                if (world.a(i, j, k) != amq.H.cm) break;
                OilPopulate.generateSurfaceDeposit(world, rand, i, j, k, 3);
                break;
            }
        }
        boolean mediumDeposit = rand.nextDouble() <= 0.0015;
        boolean bl = largeDeposit = rand.nextDouble() <= 5.0E-5;
        if (BuildCraftCore.debugMode && x == 0 && z == 0) {
            largeDeposit = true;
        }
        if (mediumDeposit || largeDeposit) {
            int cx = x;
            int cy = 20 + rand.nextInt(10);
            int cz = z;
            int r = 0;
            if (largeDeposit) {
                r = 8 + rand.nextInt(9);
            } else if (mediumDeposit) {
                r = 4 + rand.nextInt(4);
            }
            int r2 = r * r;
            for (int bx = -r; bx <= r; ++bx) {
                for (int by2 = -r; by2 <= r; ++by2) {
                    for (int bz = -r; bz <= r; ++bz) {
                        int d2 = bx * bx + by2 * by2 + bz * bz;
                        if (d2 > r2) continue;
                        world.e(bx + cx, by2 + cy, bz + cz, BuildCraftEnergy.oilStill.cm);
                    }
                }
            }
            boolean started = false;
            for (int y2 = 128; y2 >= cy; --y2) {
                if (!started && world.a(cx, y2, cz) != 0 && world.a(cx, y2, cz) != amq.N.cm && world.a(cx, y2, cz) != amq.M.cm && world.a(cx, y2, cz) != amq.x.cm) {
                    started = true;
                    if (largeDeposit) {
                        OilPopulate.generateSurfaceDeposit(world, rand, cx, y2, cz, 20 + rand.nextInt(20));
                    } else if (mediumDeposit) {
                        OilPopulate.generateSurfaceDeposit(world, rand, cx, y2, cz, 5 + rand.nextInt(5));
                    }
                    int ymax = 0;
                    if (largeDeposit) {
                        ymax = y2 + 30 < 128 ? y2 + 30 : 128;
                    } else if (mediumDeposit) {
                        ymax = y2 + 4 < 128 ? y2 + 4 : 128;
                    }
                    for (int h = y2 + 1; h <= ymax; ++h) {
                        world.e(cx, h, cz, BuildCraftEnergy.oilStill.cm);
                    }
                    continue;
                }
                if (!started) continue;
                world.e(cx, y2, cz, BuildCraftEnergy.oilStill.cm);
            }
        }
    }

    public static void generateSurfaceDeposit(yc world, Random rand, int x, int y2, int z, int radius) {
        OilPopulate.setOilWithProba(world, rand, 1.0f, x, y2, z, true);
        for (int w2 = 1; w2 <= radius; ++w2) {
            float proba = (float)(radius - w2 + 4) / (float)(radius + 4);
            for (int d = -w2; d <= w2; ++d) {
                OilPopulate.setOilWithProba(world, rand, proba, x + d, y2, z + w2, false);
                OilPopulate.setOilWithProba(world, rand, proba, x + d, y2, z - w2, false);
                OilPopulate.setOilWithProba(world, rand, proba, x + w2, y2, z + d, false);
                OilPopulate.setOilWithProba(world, rand, proba, x - w2, y2, z + d, false);
            }
        }
        for (int dx = x - radius; dx <= x + radius; ++dx) {
            for (int dz = z - radius; dz <= z + radius; ++dz) {
                if (world.a(dx, y2 - 1, dz) == BuildCraftEnergy.oilStill.cm || !OilPopulate.isOil(world, dx + 1, y2 - 1, dz) || !OilPopulate.isOil(world, dx - 1, y2 - 1, dz) || !OilPopulate.isOil(world, dx, y2 - 1, dz + 1) || !OilPopulate.isOil(world, dx, y2 - 1, dz - 1)) continue;
                OilPopulate.setOilWithProba(world, rand, 1.0f, dx, y2, dz, true);
            }
        }
    }

    private static boolean isOil(yc world, int x, int y2, int z) {
        return world.a(x, y2, z) == BuildCraftEnergy.oilStill.cm || world.a(x, y2, z) == BuildCraftEnergy.oilMoving.cm;
    }

    public static void setOilWithProba(yc world, Random rand, float proba, int x, int y2, int z, boolean force) {
        if (rand.nextFloat() <= proba && world.a(x, y2 - 2, z) != 0 || force) {
            boolean adjacentOil = false;
            for (int d = -1; d <= 1; ++d) {
                if (!OilPopulate.isOil(world, x + d, y2 - 1, z) && !OilPopulate.isOil(world, x - d, y2 - 1, z) && !OilPopulate.isOil(world, x, y2 - 1, z + d) && !OilPopulate.isOil(world, x, y2 - 1, z - d)) continue;
                adjacentOil = true;
            }
            if (adjacentOil || force) {
                if (world.a(x, y2, z) == amq.D.cm || world.a(x, y2, z) == amq.E.cm || OilPopulate.isOil(world, x, y2, z)) {
                    world.e(x, y2, z, BuildCraftEnergy.oilStill.cm);
                } else {
                    world.e(x, y2, z, 0);
                }
                world.e(x, y2 - 1, z, BuildCraftEnergy.oilStill.cm);
            }
        }
    }
}

