/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.BlockIndex;
import buildcraft.core.EntityBlock;
import buildcraft.core.IMachine;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.factory.TileMachine;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TilePump
extends TileMachine
implements IMachine,
IPowerReceptor,
ITankContainer {
    public static int MAX_LIQUID = 1000;
    EntityBlock tube;
    private TreeMap blocksToPump = new TreeMap();
    LiquidTank tank;
    double tubeY = Double.NaN;
    int aimY = 0;
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TilePump() {
        this.powerProvider.configure(20, 1, 10, 10, 100);
        this.tank = new LiquidTank(MAX_LIQUID);
    }

    @Override
    public void g() {
        LiquidStack liquid;
        super.g();
        if (this.tube == null) {
            return;
        }
        if (!CoreProxy.proxy.isRenderWorld(this.k)) {
            if (this.tube.u - (double)this.aimY > 0.01) {
                this.tubeY = this.tube.u - 0.01;
                this.setTubePosition();
                if (CoreProxy.proxy.isSimulating(this.k)) {
                    this.sendNetworkUpdate();
                }
                return;
            }
            if (this.tank.getLiquid() == null || this.tank.getLiquid().amount <= 0) {
                BlockIndex index = this.getNextIndexToPump(false);
                if (this.isPumpableLiquid(index)) {
                    LiquidStack liquidToPump = Utils.liquidFromBlockId(this.k.a(index.i, index.j, index.k));
                    if (this.tank.fill(liquidToPump, false) == liquidToPump.amount && this.powerProvider.useEnergy(10.0f, 10.0f, true) == 10.0f) {
                        index = this.getNextIndexToPump(true);
                        if (liquidToPump.itemID != amq.E.cm || BuildCraftCore.consumeWaterSources) {
                            this.k.e(index.i, index.j, index.k, 0);
                        }
                        this.tank.fill(liquidToPump, true);
                        if (CoreProxy.proxy.isSimulating(this.k)) {
                            this.sendNetworkUpdate();
                        }
                    }
                } else if (this.k.G() % 100L == 0L) {
                    this.initializePumpFromPosition(this.l, this.aimY, this.n);
                    if (this.getNextIndexToPump(false) == null) {
                        for (int y2 = this.m - 1; y2 > 0; --y2) {
                            if (this.isLiquid(new BlockIndex(this.l, y2, this.n))) {
                                this.aimY = y2;
                                return;
                            }
                            if (this.k.a(this.l, y2, this.n) == 0) continue;
                            return;
                        }
                    }
                }
            }
        }
        if ((liquid = this.tank.getLiquid()) != null && liquid.amount >= 0) {
            for (int i = 0; i < 6; ++i) {
                Position p = new Position(this.l, this.m, this.n, ForgeDirection.values()[i]);
                p.moveForwards(1.0);
                any tile = this.k.q((int)p.x, (int)p.y, (int)p.z);
                if (!(tile instanceof ITankContainer)) continue;
                int moved = ((ITankContainer)tile).fill(p.orientation.getOpposite(), liquid, true);
                this.tank.drain(moved, true);
                if (liquid.amount <= 0) break;
            }
        }
    }

    @Override
    public void initialize() {
        this.tube = new EntityBlock(this.k);
        this.tube.texture = 102;
        this.tube.u = !Double.isNaN(this.tubeY) ? this.tubeY : (double)this.m;
        this.tubeY = this.tube.u;
        if (this.aimY == 0) {
            this.aimY = this.m;
        }
        this.setTubePosition();
        this.k.d((lq)this.tube);
        if (CoreProxy.proxy.isSimulating(this.k)) {
            this.sendNetworkUpdate();
        }
    }

    private BlockIndex getNextIndexToPump(boolean remove) {
        LinkedList topLayer = null;
        int topLayerHeight = 0;
        for (Integer layer : this.blocksToPump.keySet()) {
            if (layer <= topLayerHeight || ((LinkedList)this.blocksToPump.get(layer)).size() == 0) continue;
            topLayerHeight = layer;
            topLayer = (LinkedList)this.blocksToPump.get(layer);
        }
        if (topLayer != null) {
            if (remove) {
                BlockIndex index = (BlockIndex)topLayer.pop();
                if (topLayer.size() == 0) {
                    this.blocksToPump.remove(topLayerHeight);
                }
                return index;
            }
            return (BlockIndex)topLayer.getLast();
        }
        return null;
    }

    private void initializePumpFromPosition(int x, int y2, int z) {
        int liquidId = 0;
        TreeSet markedBlocks = new TreeSet();
        TreeSet lastFound = new TreeSet();
        if (!this.blocksToPump.containsKey(y2)) {
            this.blocksToPump.put(y2, new LinkedList());
        }
        LinkedList pumpList = (LinkedList)this.blocksToPump.get(y2);
        liquidId = this.k.a(x, y2, z);
        if (!this.isLiquid(new BlockIndex(x, y2, z))) {
            return;
        }
        this.addToPumpIfLiquid(new BlockIndex(x, y2, z), markedBlocks, lastFound, pumpList, liquidId);
        while (lastFound.size() > 0) {
            TreeSet visitIteration = new TreeSet(lastFound);
            lastFound.clear();
            for (BlockIndex index : visitIteration) {
                this.addToPumpIfLiquid(new BlockIndex(index.i + 1, index.j, index.k), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i - 1, index.j, index.k), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j, index.k + 1), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j, index.k - 1), markedBlocks, lastFound, pumpList, liquidId);
                if (!this.blocksToPump.containsKey(index.j + 1)) {
                    this.blocksToPump.put(index.j + 1, new LinkedList());
                }
                pumpList = (LinkedList)this.blocksToPump.get(index.j + 1);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j + 1, index.k), markedBlocks, lastFound, pumpList, liquidId);
            }
        }
    }

    public void addToPumpIfLiquid(BlockIndex index, TreeSet markedBlocks, TreeSet lastFound, LinkedList pumpList, int liquidId) {
        if (liquidId != this.k.a(index.i, index.j, index.k)) {
            return;
        }
        if (!markedBlocks.contains(index)) {
            markedBlocks.add(index);
            if ((index.i - this.l) * (index.i - this.l) + (index.k - this.n) * (index.k - this.n) > 4096) {
                return;
            }
            if (this.isPumpableLiquid(index)) {
                pumpList.push(index);
            }
            if (this.isLiquid(index)) {
                lastFound.add(index);
            }
        }
    }

    private boolean isPumpableLiquid(BlockIndex index) {
        return this.isLiquid(index) && this.k.h(index.i, index.j, index.k) == 0;
    }

    private boolean isLiquid(BlockIndex index) {
        return index != null && Utils.liquidFromBlockId(this.k.a(index.i, index.j, index.k)) != null;
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("internalLiquid")) {
            this.tank.setLiquid(new LiquidStack(nbttagcompound.e("liquidId"), nbttagcompound.e("internalLiquid")));
        } else if (nbttagcompound.b("tank")) {
            this.tank.setLiquid(LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound.l("tank")));
        }
        this.aimY = nbttagcompound.e("aimY");
        this.tubeY = nbttagcompound.g("tubeY");
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.powerProvider.configure(20, 1, 10, 10, 100);
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        if (this.tank.getLiquid() != null) {
            nbttagcompound.a("tank", (cd)this.tank.getLiquid().writeToNBT(new bq()));
        }
        nbttagcompound.a("aimY", this.aimY);
        if (this.tube != null) {
            nbttagcompound.a("tubeY", (float)this.tube.u);
        } else {
            nbttagcompound.a("tubeY", (float)this.m);
        }
    }

    @Override
    public boolean isActive() {
        return this.isPumpableLiquid(this.getNextIndexToPump(false));
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(4, 1, 0);
        if (this.tank.getLiquid() != null) {
            payload.intPayload[0] = this.tank.getLiquid().itemID;
            payload.intPayload[1] = this.tank.getLiquid().itemMeta;
            payload.intPayload[2] = this.tank.getLiquid().amount;
        } else {
            payload.intPayload[0] = 0;
            payload.intPayload[1] = 0;
            payload.intPayload[2] = 0;
        }
        payload.intPayload[3] = this.aimY;
        payload.floatPayload[0] = (float)this.tubeY;
        return payload;
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        this.handleUpdatePacket(packet);
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        if (packet.payload.intPayload[0] > 0) {
            this.tank.setLiquid(new LiquidStack(packet.payload.intPayload[0], packet.payload.intPayload[2], packet.payload.intPayload[1]));
        } else {
            this.tank.setLiquid(null);
        }
        this.aimY = packet.payload.intPayload[3];
        this.tubeY = packet.payload.floatPayload[0];
        this.setTubePosition();
    }

    private void setTubePosition() {
        if (this.tube != null) {
            this.tube.iSize = 0.5;
            this.tube.kSize = 0.5;
            this.tube.jSize = (double)this.m - this.tube.u;
            this.tube.b((float)this.l + 0.25f, this.tubeY, (float)this.n + 0.25f);
        }
    }

    @Override
    public void w_() {
        super.w_();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.tube != null) {
            CoreProxy.proxy.removeEntity(this.tube);
            this.tube = null;
            this.tubeY = Double.NaN;
            this.aimY = 0;
            this.blocksToPump.clear();
        }
    }

    @Override
    public boolean manageLiquids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex == 0) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tank;
    }
}

