/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineFermenter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import mistaqur.nei.common.ICachedRecipeWithLiquidTank;
import mistaqur.nei.common.LiquidHelper;
import mistaqur.nei.common.LiquidTank;
import mistaqur.nei.forestry.ForestryRecipeHandler;
import net.minecraftforge.liquids.LiquidStack;

public class FermenterRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(30, 8, 16, 58);
    static Rectangle outputTank = new Rectangle(120, 8, 16, 58);
    static Point overlayTank = new Point(176, 0);
    static ArrayList fuels;

    public String getRecipeName() {
        return "Fermenter";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 31, 14, 12), "forestry.fermenter", new Object[0]));
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (fuels == null) {
            fuels = new ArrayList(FuelManager.fermenterFuel.keySet());
        }
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)ingredients[0];
            MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
            ArrayList recipes = MachineFermenter.RecipeManager.recipes;
            for (MachineFermenter.Recipe irecipe : recipes) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.liquid)) continue;
                this.arecipes.add(new CachedFermenterRecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (fuels == null) {
            fuels = new ArrayList(FuelManager.fermenterFuel.keySet());
        }
        if (outputId.equals("forestry.fermenter") && ((Object)((Object)this)).getClass() == FermenterRecipeHandler.class) {
            MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
            ArrayList recipes = MachineFermenter.RecipeManager.recipes;
            for (MachineFermenter.Recipe irecipe : recipes) {
                this.arecipes.add(new CachedFermenterRecipe(irecipe));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)results[0];
            MachineFermenter.RecipeManager cfr_ignored_1 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
            ArrayList recipes = MachineFermenter.RecipeManager.recipes;
            for (MachineFermenter.Recipe irecipe : recipes) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.output)) continue;
                this.arecipes.add(new CachedFermenterRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ur result) {
        LiquidStack t = LiquidHelper.getLiquidStack(result);
        if (t != null) {
            MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
            ArrayList recipes = MachineFermenter.RecipeManager.recipes;
            for (MachineFermenter.Recipe irecipe : recipes) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.output)) continue;
                this.arecipes.add(new CachedFermenterRecipe(irecipe).replaceMetaOnBottlerSlots(result));
            }
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
        ArrayList recipes = MachineFermenter.RecipeManager.recipes;
        for (MachineFermenter.Recipe irecipe : recipes) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ur)irecipe.resource, (ur)ingredient) && !LiquidHelper.areSameLiquid(t, irecipe.liquid)) continue;
            CachedFermenterRecipe recipe = new CachedFermenterRecipe(irecipe);
            recipe.setStacksPermutation(ingredient);
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/fermenter.png";
    }

    public class CachedFermenterRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        PositionedStack slot_resource;
        PositionedStack slot_can_output;
        PositionedStack slot_can_input;
        PositionedStack slot_input;
        LiquidTank input;
        LiquidTank output;

        public CachedFermenterRecipe(MachineFermenter.Recipe recipe) {
            super((TemplateRecipeHandler)FermenterRecipeHandler.this);
            this.input = new LiquidTank(recipe.liquid.copy(), 10000, inputTank, overlayTank);
            this.output = new LiquidTank(recipe.output.copy(), 10000, outputTank, overlayTank);
            this.input.liquid.amount = recipe.fermentationValue;
            this.output.liquid.amount = Math.round((float)recipe.fermentationValue * recipe.modifier);
            this.slot_resource = new PositionedStack((Object)recipe.resource, 80, 12);
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.input.liquid, 25, 29, 5, 29);
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.output.liquid, 145, 11, 145, 47);
            this.slot_input = input_cont[1];
            this.slot_can_input = output_cont[0];
            this.slot_can_output = output_cont[1];
        }

        public ArrayList getIngredients() {
            ArrayList<PositionedStack> cycledstacks = new ArrayList<PositionedStack>();
            cycledstacks.add(this.slot_resource);
            cycledstacks.add(this.slot_input);
            return this.getCycledIngredients(FermenterRecipeHandler.this.cycleticks / 20, cycledstacks);
        }

        public void setStacksPermutation(ur ingredient) {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(this.slot_resource);
            stacks.add(this.slot_input);
            this.setIngredientPermutation(stacks, ingredient);
        }

        public PositionedStack getResult() {
            return LiquidHelper.getSeqCycledStack(FermenterRecipeHandler.this.cycleticks / 20, this.slot_can_output);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_can_input != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(FermenterRecipeHandler.this.cycleticks / 20, this.slot_can_input));
            }
            stacks.add(new PositionedStack(fuels.get(FermenterRecipeHandler.this.cycleticks / 40 % fuels.size()), 70, 46));
            return stacks;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            res.add(this.output);
            return res;
        }

        public CachedFermenterRecipe replaceMetaOnBottlerSlots(ur ingredient) {
            if (this.slot_can_output.items.length == 1 && this.slot_can_input == null) {
                return this;
            }
            for (int i = 0; i < this.slot_can_output.items.length; ++i) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ur)ingredient, (ur)this.slot_can_output.items[i])) continue;
                this.slot_can_output.item = this.slot_can_output.items[i];
                this.slot_can_output.item.b(ingredient.j());
                this.slot_can_output.items = new ur[]{this.slot_can_output.item};
                this.slot_can_output.setPermutationToRender(0);
                this.slot_can_input.item = this.slot_can_input.items[i];
                this.slot_can_input.items = new ur[]{this.slot_can_input.item};
                this.slot_can_input.setPermutationToRender(0);
                break;
            }
            return this;
        }
    }
}

