/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import forestry.core.utils.ShapedRecipeInternal;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import mistaqur.nei.common.ICachedRecipeWithLiquidTank;
import mistaqur.nei.common.LiquidTank;
import org.lwjgl.opengl.GL11;

public abstract class ForestryRecipeHandler
extends TemplateRecipeHandler {
    public boolean hasOverlay(avf gui, rq container, int recipe) {
        return false;
    }

    public void drawForeground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        gui.bindTextureByName(this.getGuiTexture());
        this.drawExtras(gui, recipe);
        this.drawLiquidTanks(gui, recipe);
    }

    public void drawLiquidTanks(GuiContainerManager gui, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                tank.draw(gui, this.getGuiTexture());
            }
        }
    }

    protected boolean transferLiquidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.n - offset.x, mousepos.y - guiRecipe.o - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse) || tank.liquid.itemID <= 0 || !(usage ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}))) continue;
                return true;
            }
        }
        return false;
    }

    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        currenttip = super.handleTooltip(guiRecipe, currenttip, recipe);
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (guiRecipe.manager.shouldShowTooltip() && crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.n - offset.x, mousepos.y - guiRecipe.o - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"recipe") ? this.transferLiquidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"usage") && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferLiquidTank(gui, recipe, false) : button == 1 && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public abstract class CachedShapedRecipeInternal
    extends TemplateRecipeHandler.CachedRecipe {
        public int xoffset;
        public int yoffset;
        public int xproduct;
        public int yproduct;
        public ArrayList ingredients;
        public PositionedStack product;

        public CachedShapedRecipeInternal() {
            super((TemplateRecipeHandler)ForestryRecipeHandler.this);
        }

        public void setIngredients(ShapedRecipeInternal recipe) {
            try {
                int width = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedRecipeInternal.class, (Object)recipe, (int)0);
                int height = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedRecipeInternal.class, (Object)recipe, (int)1);
                Object[] items = (Object[])ObfuscationReflectionHelper.getPrivateValue(ShapedRecipeInternal.class, (Object)recipe, (int)2);
                this.product = new PositionedStack((Object)((ur)ObfuscationReflectionHelper.getPrivateValue(ShapedRecipeInternal.class, (Object)recipe, (int)3)), this.xproduct, this.yproduct);
                this.setIngredients(width, height, items);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], this.xoffset + x * 18, this.yoffset + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public PositionedStack getResult() {
            return this.product;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(ForestryRecipeHandler.this.cycleticks / 20, this.ingredients);
        }
    }
}

