/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.liquid;

import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class ExtendedLiquidTank
implements ILiquidTank {
    private LiquidStack liquid;
    private boolean changeType;
    private int capacity;

    public ExtendedLiquidTank(LiquidStack type, int capacity) {
        if (type == null) {
            this.liquid = new LiquidStack(0, 0);
            this.changeType = true;
        } else {
            this.liquid = new LiquidStack(type.itemID, 0, type.itemMeta);
        }
        this.capacity = capacity;
    }

    public ExtendedLiquidTank(int capacity) {
        this(null, capacity);
    }

    public LiquidStack getLiquid() {
        return this.liquid.copy();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean canAccept(LiquidStack type) {
        return type == null || type.itemID <= 0 || this.liquid.amount == 0 && this.changeType || this.liquid.isLiquidEqual(type);
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID <= 0) {
            return 0;
        }
        if (!this.canAccept(resource)) {
            return 0;
        }
        int tofill = Math.min(this.getCapacity() - this.liquid.amount, resource.amount);
        if (doFill && tofill > 0) {
            this.liquid.amount += tofill;
            this.liquid.itemID = resource.itemID;
            this.liquid.itemMeta = resource.itemMeta;
            this.onLiquidChanged();
        }
        return tofill;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid.amount == 0 || maxDrain <= 0) {
            return null;
        }
        int todrain = Math.min(maxDrain, this.liquid.amount);
        if (doDrain && todrain > 0) {
            this.liquid.amount -= todrain;
            this.onLiquidChanged();
        }
        return new LiquidStack(this.liquid.itemID, todrain, this.liquid.itemMeta);
    }

    public int getTankPressure() {
        return 0;
    }

    public void onLiquidChanged() {
    }

    public void fromTag(bq tag) {
        LiquidStack nbtLiquid = LiquidStack.loadLiquidStackFromNBT((bq)tag);
        if (nbtLiquid != null) {
            this.liquid = nbtLiquid;
        }
    }

    public bq toTag() {
        return this.liquid.writeToNBT(new bq());
    }
}

