/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.Quat;
import codechicken.core.Vector3;
import codechicken.core.render.CCRenderState;
import codechicken.core.render.LightModel;
import codechicken.core.render.Vertex5;
import codechicken.core.vec.ITransformation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CCModel {
    public final int vertexMode;
    public final int vp;
    public Vertex5[] verts;
    public Vector3[] normals;
    public int[] colours;
    private static final Pattern vertPattern = Pattern.compile("v(?: ([\\d\\.-]+))+");
    private static final Pattern uvwPattern = Pattern.compile("vt(?: ([\\d\\.-]+))+");
    private static final Pattern normalPattern = Pattern.compile("vn(?: ([\\d\\.-]+))+");
    private static final Pattern polyPattern = Pattern.compile("f(?: ((?:\\d*)(?:/\\d*)(?:/\\d*)))+");
    private static final Matcher vertMatcher = vertPattern.matcher("");
    private static final Matcher uvwMatcher = uvwPattern.matcher("");
    private static final Matcher normalMatcher = normalPattern.matcher("");
    private static final Matcher polyMatcher = polyPattern.matcher("");
    public static Quat[] side_quats = new Quat[]{Quat.aroundAxis(1.0, 0.0, 0.0, 0.0), Quat.aroundAxis(1.0, 0.0, 0.0, Math.PI), Quat.aroundAxis(1.0, 0.0, 0.0, 1.5707963267948966), Quat.aroundAxis(1.0, 0.0, 0.0, -1.5707963267948966), Quat.aroundAxis(0.0, 0.0, 1.0, -1.5707963267948966), Quat.aroundAxis(0.0, 0.0, 1.0, 1.5707963267948966)};
    public static Quat[] side_quatsR = new Quat[]{Quat.aroundAxis(-1.0, 0.0, 0.0, 0.0), Quat.aroundAxis(-1.0, 0.0, 0.0, Math.PI), Quat.aroundAxis(-1.0, 0.0, 0.0, 1.5707963267948966), Quat.aroundAxis(-1.0, 0.0, 0.0, -1.5707963267948966), Quat.aroundAxis(0.0, 0.0, -1.0, -1.5707963267948966), Quat.aroundAxis(0.0, 0.0, -1.0, 1.5707963267948966)};

    private CCModel(int vertexMode) {
        if (vertexMode != 7 && vertexMode != 4) {
            throw new IllegalArgumentException("Models must be GL_QUADS or GL_TRIANGLES");
        }
        this.vertexMode = vertexMode;
        this.vp = vertexMode == 7 ? 4 : 3;
    }

    public CCModel generateBox(int i, double x1, double y1, double z1, double w, double h, double d, double tx, double ty, double tw, double th, double f) {
        double x2 = x1 + w;
        double y2 = y1 + h;
        double z2 = z1 + d;
        x1 /= f;
        x2 /= f;
        y1 /= f;
        y2 /= f;
        z1 /= f;
        double u1 = (tx + d + w) / tw;
        double v1 = (ty + d) / th;
        double u2 = (tx + d * 2.0 + w) / tw;
        double v2 = ty / th;
        this.verts[i++] = new Vertex5(x1, y1, z2 /= f, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z1, u1, v1);
        this.verts[i++] = new Vertex5(x2, y1, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2);
        u1 = (tx + d) / tw;
        v1 = (ty + d) / th;
        u2 = (tx + d + w) / tw;
        v2 = ty / th;
        this.verts[i++] = new Vertex5(x2, y2, z2, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x1, y2, z2, u1, v2);
        u1 = (tx + d + w) / tw;
        v1 = (ty + d) / th;
        u2 = (tx + d) / tw;
        v2 = (ty + d + h) / th;
        this.verts[i++] = new Vertex5(x1, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x2, y1, z1, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z1, u2, v2);
        u1 = (tx + d * 2.0 + w * 2.0) / tw;
        v1 = (ty + d) / th;
        u2 = (tx + d * 2.0 + w) / tw;
        v2 = (ty + d + h) / th;
        this.verts[i++] = new Vertex5(x1, y2, z2, u1, v1);
        this.verts[i++] = new Vertex5(x1, y1, z2, u1, v2);
        this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z2, u2, v1);
        u1 = (tx + d) / tw;
        v1 = (ty + d) / th;
        u2 = tx / tw;
        v2 = (ty + d + h) / th;
        this.verts[i++] = new Vertex5(x1, y2, z2, u2, v1);
        this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x1, y1, z1, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z2, u2, v2);
        u1 = (tx + d * 2.0 + w) / tw;
        v1 = (ty + d) / th;
        u2 = (tx + d + w) / tw;
        v2 = (ty + d + h) / th;
        this.verts[i++] = new Vertex5(x2, y1, z2, u1, v2);
        this.verts[i++] = new Vertex5(x2, y1, z1, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y2, z2, u1, v1);
        return this;
    }

    public CCModel generateBlock(int i, double x1, double y1, double z1, double x2, double y2, double z2) {
        double u1 = x1 / 16.0;
        double v1 = z1 / 16.0;
        double u2 = x2 / 16.0;
        double v2 = z2 / 16.0;
        this.verts[i++] = new Vertex5(x1, y1, z2, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z1, u1, v1);
        this.verts[i++] = new Vertex5(x2, y1, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2);
        u1 = x1 / 16.0;
        v1 = z1 / 16.0;
        u2 = x2 / 16.0;
        v2 = z2 / 16.0;
        this.verts[i++] = new Vertex5(x2, y2, z2, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x1, y2, z2, u1, v2);
        u1 = x1 / 16.0;
        v1 = y1 / 16.0;
        u2 = x2 / 16.0;
        v2 = y2 / 16.0;
        this.verts[i++] = new Vertex5(x1, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x2, y1, z1, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z1, u2, v2);
        u1 = x1 / 16.0;
        v1 = y1 / 16.0;
        u2 = x2 / 16.0;
        v2 = y2 / 16.0;
        this.verts[i++] = new Vertex5(x1, y2, z2, u1, v1);
        this.verts[i++] = new Vertex5(x1, y1, z2, u1, v2);
        this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z2, u2, v1);
        u1 = z1 / 16.0;
        v1 = y1 / 16.0;
        u2 = z2 / 16.0;
        v2 = y2 / 16.0;
        this.verts[i++] = new Vertex5(x1, y2, z2, u2, v1);
        this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1);
        this.verts[i++] = new Vertex5(x1, y1, z1, u1, v2);
        this.verts[i++] = new Vertex5(x1, y1, z2, u2, v2);
        u1 = z1 / 16.0;
        v1 = y1 / 16.0;
        u2 = z2 / 16.0;
        v2 = y2 / 16.0;
        this.verts[i++] = new Vertex5(x2, y1, z2, u1, v2);
        this.verts[i++] = new Vertex5(x2, y1, z1, u2, v2);
        this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1);
        this.verts[i++] = new Vertex5(x2, y2, z2, u1, v1);
        return this;
    }

    public CCModel computeNormals() {
        return this.computeNormals(0, this.verts.length);
    }

    public CCModel computeNormals(int start, int length) {
        if (length % this.vp != 0 || start % this.vp != 0) {
            throw new IllegalArgumentException("Cannot generate normals across polygons");
        }
        if (this.normals == null) {
            this.normals = new Vector3[this.verts.length];
        }
        int k = 0;
        while (k < length) {
            int i = k + start;
            Vector3 diff1 = this.verts[i + 1].vec.copy().subtract(this.verts[i].vec);
            Vector3 diff2 = this.verts[i + this.vp - 1].vec.copy().subtract(this.verts[i].vec);
            this.normals[i] = diff1.crossProduct(diff2).normalize();
            int d = 1;
            while (d < this.vp) {
                this.normals[i + d] = this.normals[i].copy();
                ++d;
            }
            k += this.vp;
        }
        return this;
    }

    public CCModel computeLighting(LightModel light) {
        this.colours = new int[this.verts.length];
        int k = 0;
        while (k < this.verts.length) {
            this.colours[k] = light.apply(0xFFFFFF, this.normals[k]);
            ++k;
        }
        return this;
    }

    public CCModel smoothNormals() {
        ArrayList<PositionNormalEntry> map = new ArrayList<PositionNormalEntry>();
        int k = 0;
        while (k < this.verts.length) {
            block5: {
                Vector3 vec = this.verts[k].vec;
                for (PositionNormalEntry e : map) {
                    if (!e.positionEqual(vec)) continue;
                    e.addNormal(this.normals[k]);
                    break block5;
                }
                map.add(new PositionNormalEntry(vec).addNormal(this.normals[k]));
            }
            ++k;
        }
        for (PositionNormalEntry e : map) {
            if (e.normals.size() <= 1) continue;
            Vector3 new_n = new Vector3();
            for (Vector3 n : e.normals) {
                new_n.add(n);
            }
            new_n.normalize();
            for (Vector3 n : e.normals) {
                n.set(new_n);
            }
        }
        return this;
    }

    public CCModel rotate(Quat quat) {
        return this.rotate(quat, new Vector3());
    }

    public CCModel rotate(Quat quat, Vector3 point) {
        boolean translate = !point.isZero();
        int k = 0;
        while (k < this.verts.length) {
            if (translate) {
                this.verts[k].vec.subtract(point).rotate(quat).add(point);
            } else {
                this.verts[k].vec.rotate(quat);
            }
            ++k;
        }
        if (this.normals != null) {
            k = 0;
            while (k < this.normals.length) {
                quat.rotate(this.normals[k]);
                ++k;
            }
        }
        return this;
    }

    public CCModel scale(double f) {
        return this.scale(new Vector3(f, f, f), new Vector3());
    }

    public CCModel scale(double f, Vector3 point) {
        return this.scale(new Vector3(f, f, f), point);
    }

    public CCModel scale(Vector3 f) {
        return this.scale(f, new Vector3());
    }

    public CCModel scale(Vector3 f, Vector3 point) {
        boolean translate = !point.isZero();
        int k = 0;
        while (k < this.verts.length) {
            if (translate) {
                this.verts[k].vec.subtract(point).multiply(f).add(point);
            } else {
                this.verts[k].vec.multiply(f);
            }
            ++k;
        }
        return this;
    }

    public CCModel translate(Vector3 offset) {
        int k = 0;
        while (k < this.verts.length) {
            this.verts[k].vec.add(offset);
            ++k;
        }
        return this;
    }

    public void render(double x2, double y2, double z2, double u2, double v) {
        this.render(0, this.verts.length, new Vector3(x2, y2, z2).translation(), u2, v);
    }

    public void render(ITransformation t, double u2, double v) {
        this.render(0, this.verts.length, t, u2, v);
    }

    public void render(int start, int length, ITransformation t, double u2, double v) {
        boolean useNormal = CCRenderState.useNormals() && this.normals != null;
        boolean useColour = CCRenderState.useModelColours() && this.colours != null;
        baz tess = baz.a;
        int k = 0;
        while (k < length) {
            Vector3 vec;
            if (useNormal) {
                Vector3 normal = this.normals[start + k];
                tess.b((float)normal.x, (float)normal.y, (float)normal.z);
            }
            if (useColour) {
                tess.d(this.colours[start + k]);
            }
            Vertex5 vert = this.verts[start + k];
            if (t != null) {
                vec = vert.vec.copy();
                t.transform(vec);
            } else {
                vec = vert.vec;
            }
            tess.a(vec.x, vec.y, vec.z, vert.u + u2, vert.v + v);
            ++k;
        }
    }

    public static CCModel quadModel(int numVerts) {
        return CCModel.newModel(7, numVerts);
    }

    public static CCModel triModel(int numVerts) {
        return CCModel.newModel(4, numVerts);
    }

    public static CCModel newModel(int vertexMode, int numVerts) {
        CCModel model = CCModel.newModel(vertexMode);
        model.verts = new Vertex5[numVerts];
        return model;
    }

    public static CCModel newModel(int vertexMode) {
        return new CCModel(vertexMode);
    }

    private static double[] parseDoubles(String s, String token) {
        String[] as = s.split(token);
        double[] values = new double[as.length];
        int i = 0;
        while (i < as.length) {
            values[i] = Double.parseDouble(as[i]);
            ++i;
        }
        return values;
    }

    private static void illegalAssert(boolean b, String err) {
        if (!b) {
            throw new IllegalArgumentException(err);
        }
    }

    private static void assertMatch(Matcher m, String s) {
        m.reset(s);
        CCModel.illegalAssert(m.matches(), "Malformed line: " + s);
    }

    public static Map parseObjModels(InputStream input) throws IOException {
        String line;
        HashMap<String, CCModel> modelMap = new HashMap<String, CCModel>();
        ArrayList<Vector3> verts = new ArrayList<Vector3>();
        ArrayList<Vector3> uvs = new ArrayList<Vector3>();
        ArrayList<Vector3> normals = new ArrayList<Vector3>();
        ArrayList<int[]> triangles = new ArrayList<int[]>();
        String modelName = "unnamed";
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            double[] values;
            if ((line = line.replaceAll("\\s+", " ").trim()).startsWith("#") || line.length() == 0) continue;
            if (line.startsWith("v ")) {
                CCModel.assertMatch(vertMatcher, line);
                values = CCModel.parseDoubles(line.substring(2), " ");
                CCModel.illegalAssert(values.length >= 3, "Vertices must have x, y and z components");
                verts.add(new Vector3(values[0], values[2], values[1]));
                continue;
            }
            if (line.startsWith("vt ")) {
                CCModel.assertMatch(uvwMatcher, line);
                values = CCModel.parseDoubles(line.substring(3), " ");
                CCModel.illegalAssert(values.length >= 2, "Tex Coords must have u, and v components");
                uvs.add(new Vector3(values[0], 1.0 - values[1], 0.0));
                continue;
            }
            if (line.startsWith("vn ")) {
                CCModel.assertMatch(normalMatcher, line);
                values = CCModel.parseDoubles(line.substring(3), " ");
                CCModel.illegalAssert(values.length >= 3, "Normals must have x, y and z components");
                normals.add(new Vector3(values[0], values[2], values[1]).normalize());
                continue;
            }
            if (line.startsWith("f ")) {
                CCModel.assertMatch(polyMatcher, line);
                String[] av = line.substring(2).split(" ");
                CCModel.illegalAssert(av.length >= 3, "Polygons must have at least 3 vertices");
                int[][] polyVerts = new int[av.length][3];
                int i = 0;
                while (i < av.length) {
                    String[] as = av[i].split("/");
                    int p = 0;
                    while (p < as.length) {
                        if (as[p].length() > 0) {
                            polyVerts[i][p] = Integer.parseInt(as[p]);
                        }
                        ++p;
                    }
                    ++i;
                }
                i = 2;
                while (i < av.length) {
                    triangles.add(polyVerts[0]);
                    triangles.add(polyVerts[i]);
                    triangles.add(polyVerts[i - 1]);
                    ++i;
                }
            }
            if (!line.startsWith("g ")) continue;
            if (!triangles.isEmpty()) {
                modelMap.put(modelName, CCModel.createModel(verts, uvs, normals, triangles));
                triangles.clear();
            }
            modelName = line.substring(2);
        }
        if (!triangles.isEmpty()) {
            modelMap.put(modelName, CCModel.createModel(verts, uvs, normals, triangles));
        }
        return modelMap;
    }

    public static Map parseObjModels(String s) {
        try {
            return CCModel.parseObjModels(CCModel.class.getResourceAsStream(s));
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load model: " + s, e);
        }
    }

    public static CCModel createModel(List verts, List uvs, List normals, List triangles) {
        if (triangles.size() < 3 || triangles.size() % 3 != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for model: " + triangles.size());
        }
        boolean hasNormals = ((int[])triangles.get(0))[1] > 0;
        CCModel model = CCModel.newModel(4, triangles.size());
        if (hasNormals) {
            model.normals = new Vector3[triangles.size()];
        }
        int i = 0;
        while (i < triangles.size()) {
            int[] ai = (int[])triangles.get(i);
            Vector3 vert = ((Vector3)verts.get(ai[0] - 1)).copy();
            Vector3 uv = ai[1] <= 0 ? new Vector3() : ((Vector3)uvs.get(ai[1] - 1)).copy();
            if (ai[2] > 0 != hasNormals) {
                throw new IllegalArgumentException("Normals are an all or nothing deal here.");
            }
            model.verts[i] = new Vertex5(vert, uv.x, uv.y);
            if (hasNormals) {
                model.normals[i] = ((Vector3)normals.get(ai[2] - 1)).copy();
            }
            ++i;
        }
        return model;
    }

    public CCModel sidedCopy(int side1, int side2, Vector3 point) {
        return this.rotatedCopy(side_quatsR[side1].copy().multiply(side_quats[side2]), point);
    }

    public CCModel rotatedCopy(Quat quat) {
        return this.rotatedCopy(quat, new Vector3());
    }

    public CCModel rotatedCopy(Quat quat, Vector3 point) {
        CCModel model = CCModel.newModel(this.vertexMode, this.verts.length);
        CCModel.copy(this, 0, model, 0, model.verts.length);
        return model.rotate(quat, point);
    }

    public static void copy(CCModel src, int srcpos, CCModel dest, int destpos, int length) {
        int k = 0;
        while (k < length) {
            dest.verts[destpos + k] = src.verts[srcpos + k].copy();
            ++k;
        }
        if (src.normals != null) {
            if (dest.normals == null) {
                dest.normals = new Vector3[dest.verts.length];
            }
            k = 0;
            while (k < length) {
                dest.normals[destpos + k] = src.normals[srcpos + k].copy();
                ++k;
            }
        }
        if (src.colours != null) {
            if (dest.colours == null) {
                dest.colours = new int[dest.verts.length];
            }
            System.arraycopy(src.colours, srcpos, dest.colours, destpos, length);
        }
    }

    public static void generateSidedModels(CCModel[] models, int side, Vector3 point) {
        int s = 0;
        while (s < 6) {
            if (s != side) {
                models[s] = models[side].sidedCopy(side, s, point);
            }
            ++s;
        }
    }

    public static void generateSidedModelsH(CCModel[] models, int side, Vector3 point) {
        int s = 2;
        while (s < 6) {
            if (s != side) {
                models[s] = models[side].sidedCopy(side, s, point);
            }
            ++s;
        }
    }

    public CCModel generateBackface(int srcpos, int destpos, int length) {
        if (srcpos + length > destpos) {
            throw new IllegalArgumentException("Overlapping src and dest arrays");
        }
        if (srcpos % this.vp != 0 || destpos % this.vp != 0 || length % this.vp != 0) {
            throw new IllegalArgumentException("Vertices do not align with polygons");
        }
        int[][] o = new int[][]{new int[2], {1, this.vp - 1}, {2, this.vp - 2}, {3, this.vp - 3}};
        int i = 0;
        while (i < length) {
            int b = i / this.vp * this.vp;
            int d = i % this.vp;
            int di2 = destpos + b + o[d][1];
            int si = srcpos + b + o[d][0];
            this.verts[di2] = new Vertex5(this.verts[si]);
            if (this.normals != null && this.normals[si] != null) {
                this.normals[di2] = this.normals[si].copy().multiply(-1.0);
            }
            ++i;
        }
        return this;
    }

    public CCModel generateSidedParts(int side, Vector3 point) {
        if (this.verts.length % (6 * this.vp) != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for sided part generation");
        }
        int length = this.verts.length / 6;
        int s = 0;
        while (s < 6) {
            if (s != side) {
                this.generateSidedPart(side, s, point, length * side, length * s, length);
            }
            ++s;
        }
        return this;
    }

    public CCModel generateSidedPartsH(int side, Vector3 point) {
        if (this.verts.length % (4 * this.vp) != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for sided part generation");
        }
        int length = this.verts.length / 4;
        int s = 2;
        while (s < 6) {
            if (s != side) {
                this.generateSidedPart(side, s, point, length * (side - 2), length * (s - 2), length);
            }
            ++s;
        }
        return this;
    }

    public CCModel generateSidedPart(int side1, int side2, Vector3 point, int srcpos, int destpos, int length) {
        return this.generateRotatedPart(side_quatsR[side1].copy().multiply(side_quats[side2]), point, srcpos, destpos, length);
    }

    public CCModel generateRotatedPart(Quat quat, Vector3 point, int srcpos, int destpos, int length) {
        int k = 0;
        while (k < length) {
            this.verts[destpos + k] = this.verts[srcpos + k].copy();
            this.verts[destpos + k].vec.subtract(point).rotate(quat).add(point);
            ++k;
        }
        if (this.normals != null) {
            k = 0;
            while (k < length) {
                this.normals[destpos + k] = this.normals[srcpos + k].copy().rotate(quat);
                ++k;
            }
        }
        return this;
    }

    public static CCModel combine(Collection models) {
        if (models.isEmpty()) {
            return null;
        }
        int numVerts = 0;
        int vertexMode = -1;
        for (CCModel model : models) {
            if (vertexMode == -1) {
                vertexMode = model.vertexMode;
            }
            if (vertexMode != model.vertexMode) {
                throw new IllegalArgumentException("Cannot combine models with different vertex modes");
            }
            numVerts += model.verts.length;
        }
        CCModel c_model = CCModel.newModel(vertexMode, numVerts);
        int i = 0;
        for (CCModel model : models) {
            CCModel.copy(model, 0, c_model, i, model.verts.length);
            i += model.verts.length;
        }
        return c_model;
    }

    public CCModel twoFacedCopy() {
        CCModel model = CCModel.newModel(this.vertexMode, this.verts.length * 2);
        CCModel.copy(this, 0, model, 0, this.verts.length);
        model.generateBackface(0, this.verts.length, this.verts.length);
        return model;
    }

    public CCModel copy() {
        CCModel model = CCModel.newModel(this.vertexMode, this.verts.length);
        CCModel.copy(this, 0, model, 0, this.verts.length);
        return model;
    }

    private static class PositionNormalEntry {
        public Vector3 pos;
        public LinkedList normals = new LinkedList();

        public PositionNormalEntry(Vector3 position) {
            this.pos = position;
        }

        public boolean positionEqual(Vector3 v) {
            return this.pos.x == v.x && this.pos.y == v.y && this.pos.z == v.z;
        }

        public PositionNormalEntry addNormal(Vector3 normal) {
            this.normals.add(normal);
            return this;
        }
    }
}

