/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.vec;

import codechicken.core.Vector3;
import codechicken.core.vec.ITransformation;
import codechicken.core.vec.Matrix4;
import java.util.ArrayList;

public class TransformationList
implements ITransformation {
    private ArrayList transformations = new ArrayList();
    private Matrix4 mat;

    public TransformationList add(ITransformation t) {
        if (this.mat != null) {
            throw new RuntimeException("List already compiled");
        }
        this.transformations.add(t);
        return this;
    }

    public Matrix4 compile() {
        if (this.mat == null) {
            this.mat = new Matrix4();
            for (ITransformation t : this.transformations) {
                t.apply(this.mat);
            }
        }
        return this.mat;
    }

    @Override
    public void transform(Vector3 vec) {
        if (this.mat != null) {
            this.mat.transform(vec);
        } else {
            for (ITransformation t : this.transformations) {
                t.transform(vec);
            }
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.multiply(this.compile());
    }
}

