/*
 * Decompiled with CFR 0.152.
 */
package connectfour;

import connectfour.Outcome;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class MatchData
implements Serializable {
    private Calendar m_timestamp;
    private String m_firstPlayerName;
    private String m_secondPlayerName;
    private Outcome m_outcome;
    public static final DateFormat SQL_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final long serialVersionUID = -1480322574234886133L;

    public MatchData(String sqlTimestamp, String firstPlayerName, String secondPlayerName, Outcome outcome) throws IllegalArgumentException {
        this(MatchData.parseFromSQLString(sqlTimestamp), firstPlayerName, secondPlayerName, outcome);
    }

    public MatchData(Calendar timestamp, String firstPlayerName, String secondPlayerName, Outcome outcome) throws IllegalArgumentException {
        if (timestamp == null || firstPlayerName == null || secondPlayerName == null || outcome == null) {
            throw new IllegalArgumentException("null parameter given to MatchData constructor");
        }
        this.m_timestamp = timestamp;
        this.m_firstPlayerName = firstPlayerName;
        this.m_secondPlayerName = secondPlayerName;
        this.m_outcome = outcome;
    }

    public Calendar getTimestamp() {
        return this.m_timestamp;
    }

    public String getTimestampSQLString() {
        return MatchData.convertToSQLString(this.m_timestamp);
    }

    public String getFirstPlayerName() {
        return this.m_firstPlayerName;
    }

    public String getSecondPlayerName() {
        return this.m_secondPlayerName;
    }

    public Outcome getOutcome() {
        return this.m_outcome;
    }

    public boolean setTimestamp(Calendar timestamp) {
        if (timestamp == null) {
            return false;
        }
        this.m_timestamp = timestamp;
        return true;
    }

    public boolean setFirstPlayerName(String firstPlayerName) {
        if (firstPlayerName == null) {
            return false;
        }
        this.m_firstPlayerName = firstPlayerName;
        return true;
    }

    public boolean setSecondPlayerName(String secondPlayerName) {
        if (secondPlayerName == null) {
            return false;
        }
        this.m_secondPlayerName = secondPlayerName;
        return true;
    }

    public boolean setOutcome(Outcome outcome) {
        if (outcome == null) {
            return false;
        }
        this.m_outcome = outcome;
        return true;
    }

    public static String convertToSQLString(Calendar timestamp) {
        if (timestamp == null) {
            return null;
        }
        return SQL_TIMESTAMP_FORMAT.format(timestamp.getTime());
    }

    public static Calendar parseFromSQLString(String sqlTimestamp) {
        if (sqlTimestamp == null) {
            return null;
        }
        Calendar timestamp = Calendar.getInstance();
        try {
            timestamp.setTime(SQL_TIMESTAMP_FORMAT.parse(sqlTimestamp));
        }
        catch (ParseException e) {
            return null;
        }
        return timestamp;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MatchData)) {
            return false;
        }
        MatchData x = (MatchData)o;
        if (!(this.m_firstPlayerName.equalsIgnoreCase(x.m_firstPlayerName) && this.m_secondPlayerName.equalsIgnoreCase(x.m_secondPlayerName) || this.m_firstPlayerName.equalsIgnoreCase(x.m_secondPlayerName) && this.m_secondPlayerName.equalsIgnoreCase(x.m_firstPlayerName))) {
            return false;
        }
        return this.m_timestamp.equals(x.m_timestamp) && this.m_outcome.equals((Object)x.m_outcome);
    }

    public String toString() {
        return String.valueOf(this.m_firstPlayerName) + " vs. " + this.m_secondPlayerName + ": " + this.m_outcome.toString();
    }
}

