/*
 * Decompiled with CFR 0.152.
 */
package dbms;

import connectfour.MatchData;
import connectfour.Outcome;
import dbms.DBMS;
import dbms.DBMSListener;
import dbms.SQLResult;
import dbms.SQLResultRow;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.sqlite.JDBC;
import server.DatabaseServer;

public class SQLiteDBMS
extends UnicastRemoteObject
implements DBMS {
    private String m_databaseFileName;
    private Connection m_database = null;
    private Statement m_statement = null;
    private Vector<DBMSListener> m_listeners = new Vector();
    private boolean m_initialized = false;
    public static final String DEFAULT_DATABASE_FILENAME = "users.sql";
    public static final String USER_DATA_TABLENAME = "UserData";
    public static final String GAME_HISTORY_TABLENAME = "GameHistory";
    private static final long serialVersionUID = 2928990798728092201L;

    @Override
    public boolean initialize() {
        if (this.m_initialized) {
            return false;
        }
        this.m_databaseFileName = DEFAULT_DATABASE_FILENAME;
        DatabaseServer.console.writeLine("Connecting to SQL Database: " + this.m_databaseFileName);
        try {
            DriverManager.registerDriver(new JDBC());
            this.m_database = DriverManager.getConnection("jdbc:sqlite:" + this.m_databaseFileName);
            this.m_statement = this.m_database.createStatement();
            DatabaseServer.console.writeLine("Connected to SQL Database");
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Unable to initialize SQLite Database: " + e.getMessage());
            return false;
        }
        this.createTables();
        this.m_initialized = true;
        return true;
    }

    @Override
    public void createTables() {
        this.createUserDataTable();
        this.createGameHistoryTable();
    }

    @Override
    public void dropTables() {
        this.dropUserDataTable();
        this.dropGameHistoryTable();
    }

    @Override
    public void clearTables() {
        this.dropTables();
        this.createTables();
    }

    @Override
    public void dropUserDataTable() {
        try {
            this.m_statement.executeUpdate("DROP TABLE IF EXISTS UserData");
            DatabaseServer.console.writeLine("Dropped table UserData");
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error dropping table UserData table: " + e.getMessage());
        }
    }

    @Override
    public void dropGameHistoryTable() {
        try {
            this.m_statement.executeUpdate("DROP TABLE IF EXISTS GameHistory");
            DatabaseServer.console.writeLine("Dropped table GameHistory");
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error dropping table GameHistory table: " + e.getMessage());
        }
    }

    @Override
    public void createUserDataTable() {
        try {
            boolean tableExists;
            boolean bl = tableExists = new SQLResult(this.m_statement.executeQuery("SELECT name FROM sqlite_master WHERE type = 'table' AND name = 'UserData'")).getData().size() != 0;
            if (!tableExists) {
                this.m_statement.executeUpdate("CREATE TABLE IF NOT EXISTS UserData (UserName\t\t\tVARCHAR(32)\t\tNOT NULL,Password\t\t\tVARCHAR(32)\t\tNOT NULL,LastLogin\t\t\tDATETIME\t\tNOT NULL,JoinDate\t\t\tDATETIME\t\tNOT NULL,Wins\t\t\t\tINT\t\t\t\tNOT NULL,Losses\t\t\t\tINT\t\t\t\tNOT NULL,Draws\t\t\t\tINT\t\t\t\tNOT NULL,PRIMARY KEY(UserName))");
            }
            if (!tableExists) {
                DatabaseServer.console.writeLine("Created table UserData");
            }
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error creating table UserData table: " + e.getMessage());
        }
    }

    @Override
    public void createGameHistoryTable() {
        try {
            boolean tableExists;
            boolean bl = tableExists = new SQLResult(this.m_statement.executeQuery("SELECT name FROM sqlite_master WHERE type = 'table' AND name = 'GameHistory'")).getData().size() != 0;
            if (!tableExists) {
                this.m_statement.executeUpdate("CREATE TABLE IF NOT EXISTS GameHistory (GameDate\t\t\tDATETIME\t\tNOT NULL,FirstPlayer\t\tVARCHAR(32)\t\tNOT NULL,SecondPlayer\t\tVARCHAR(32)\t\tNOT NULL,Outcome\t\t\tTINYINT\t\t\tNOT NULL,PRIMARY KEY(GameDate, FirstPlayer, SecondPlayer),FOREIGN KEY(FirstPlayer) REFERENCES UserData(UserName),FOREIGN KEY(SecondPlayer) REFERENCES UserData(UserName))");
            }
            if (!tableExists) {
                DatabaseServer.console.writeLine("Created table GameHistory");
            }
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error creating table GameHistory table: " + e.getMessage());
        }
    }

    @Override
    public boolean createUser(String userName, String password) throws RemoteException {
        boolean userCreated;
        block5: {
            if (userName == null || password == null) {
                return false;
            }
            try {
                if (new SQLResult(this.m_statement.executeQuery("SELECT * FROM UserData WHERE UserName = '" + userName + "' ")).getRowCount() == 0) break block5;
                return false;
            }
            catch (SQLException e) {
                DatabaseServer.console.writeLine("Error adding user \"" + userName + "\" to database: " + e.getMessage());
                return false;
            }
        }
        boolean bl = userCreated = this.m_statement.executeUpdate("INSERT INTO UserData VALUES('" + userName + "', " + "'" + password + "', " + "CURRENT_TIMESTAMP, " + "CURRENT_TIMESTAMP, " + "'0'," + "'0'," + "'0'" + ")") != 0;
        if (userCreated) {
            DatabaseServer.console.writeLine("Added user \"" + userName + "\" to database");
        }
        return userCreated;
    }

    @Override
    public String[] getUserNames() throws RemoteException {
        try {
            SQLResult users = new SQLResult(this.m_statement.executeQuery("SELECT * FROM UserData"));
            String[] userNames = new String[users.getRowCount()];
            int i = 0;
            while (i < users.getRowCount()) {
                userNames[i] = users.getElement(i, 0);
                ++i;
            }
            DatabaseServer.console.writeLine("Retrieved user name list from database");
            return userNames;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error user name list from database: " + e.getMessage());
            return null;
        }
    }

    @Override
    public String[] getUserNamesFromHistory() throws RemoteException {
        try {
            SQLResult history = new SQLResult(this.m_statement.executeQuery("SELECT * FROM GameHistory"));
            String userName = null;
            boolean duplicateName = false;
            Vector<String> userNames = new Vector<String>();
            int i = 0;
            while (i < history.getRowCount()) {
                userName = history.getElement(i, 1).trim();
                duplicateName = false;
                int j = 0;
                while (j < userNames.size()) {
                    if (userName.equalsIgnoreCase((String)userNames.elementAt(j))) {
                        duplicateName = true;
                    }
                    ++j;
                }
                if (!duplicateName) {
                    userNames.add(userName);
                }
                userName = history.getElement(i, 2).trim();
                duplicateName = false;
                j = 0;
                while (j < userNames.size()) {
                    if (userName.equalsIgnoreCase((String)userNames.elementAt(j))) {
                        duplicateName = true;
                    }
                    ++j;
                }
                if (!duplicateName) {
                    userNames.add(userName);
                }
                ++i;
            }
            String[] data = new String[userNames.size()];
            int i2 = 0;
            while (i2 < userNames.size()) {
                data[i2] = (String)userNames.elementAt(i2);
                ++i2;
            }
            DatabaseServer.console.writeLine("Retrieved user name list from database");
            return data;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error user name list from database: " + e.getMessage());
            return null;
        }
    }

    @Override
    public boolean deleteUser(String userName) throws RemoteException {
        if (userName == null) {
            return false;
        }
        boolean userDeleted = false;
        try {
            boolean bl = userDeleted = this.m_statement.executeUpdate("DELETE FROM UserData WHERE UserName = '" + userName + "'") != 0;
            if (userDeleted) {
                DatabaseServer.console.writeLine("Deleted user \"" + userName + "\" from database");
            }
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error deleting \"" + userName + "\" from database: " + e.getMessage());
        }
        return userDeleted;
    }

    @Override
    public void deleteUserHistory(String userName) throws RemoteException {
        if (userName == null) {
            return;
        }
        try {
            this.m_statement.executeUpdate("DELETE FROM GameHistory WHERE FirstPlayer = '" + userName + "'" + "OR " + "SecondPlayer = '" + userName + "'");
            DatabaseServer.console.writeLine("Deleted history for \"" + userName + "\" from database");
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error deleting history for \"" + userName + "\" from database: " + e.getMessage());
        }
    }

    @Override
    public boolean addWin(String userName) throws RemoteException {
        if (userName == null) {
            return false;
        }
        boolean updated = false;
        try {
            updated = this.m_statement.executeUpdate("UPDATE UserData SET Wins = Wins + 1  WHERE UserName = '" + userName + "'") != 0;
            DatabaseServer.console.writeLine("Added win for \"" + userName + "\".");
            this.notifyStatsUpdate(userName);
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error adding win for \"" + userName + "\" to database: " + e.getMessage());
        }
        return updated;
    }

    @Override
    public boolean addLoss(String userName) throws RemoteException {
        if (userName == null) {
            return false;
        }
        boolean updated = false;
        try {
            updated = this.m_statement.executeUpdate("UPDATE UserData SET Losses = Losses + 1  WHERE UserName = '" + userName + "'") != 0;
            DatabaseServer.console.writeLine("Added loss for \"" + userName + "\".");
            this.notifyStatsUpdate(userName);
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error adding loss for \"" + userName + "\" to database: " + e.getMessage());
        }
        return updated;
    }

    @Override
    public boolean addDraw(String userName) throws RemoteException {
        if (userName == null) {
            return false;
        }
        boolean updated = false;
        try {
            updated = this.m_statement.executeUpdate("UPDATE UserData SET Draws = Draws + 1  WHERE UserName = '" + userName + "'") != 0;
            DatabaseServer.console.writeLine("Added draw for \"" + userName + "\".");
            this.notifyStatsUpdate(userName);
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error adding draw for \"" + userName + "\" to database: " + e.getMessage());
        }
        return updated;
    }

    @Override
    public boolean addMatch(MatchData match) throws RemoteException {
        boolean matchAdded;
        block7: {
            block6: {
                if (match == null) {
                    return false;
                }
                matchAdded = false;
                if (new SQLResult(this.m_statement.executeQuery("SELECT * FROM UserData WHERE UserName = '" + match.getFirstPlayerName() + "' ")).getRowCount() != 0) break block6;
                DatabaseServer.console.writeLine("Failed to add match for user \"" + match.getFirstPlayerName() + "\" without account");
                return false;
            }
            if (new SQLResult(this.m_statement.executeQuery("SELECT * FROM UserData WHERE UserName = '" + match.getSecondPlayerName() + "' ")).getRowCount() != 0) break block7;
            DatabaseServer.console.writeLine("Failed to add match for user \"" + match.getSecondPlayerName() + "\" without account");
            return false;
        }
        try {
            boolean bl = matchAdded = this.m_statement.executeUpdate("INSERT INTO GameHistory VALUES('" + match.getTimestampSQLString() + "', " + "'" + match.getFirstPlayerName() + "', " + "'" + match.getSecondPlayerName() + "', " + "'" + match.getOutcome().ordinal() + "'" + ")") != 0;
            if (matchAdded) {
                DatabaseServer.console.writeLine("Added match for \"" + match.getFirstPlayerName() + "\" vs. \"" + match.getSecondPlayerName() + "\" with outcome " + match.getOutcome().toString());
            }
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error adding match between \"" + match.getFirstPlayerName() + "\" vs. \"" + match.getSecondPlayerName() + "\": " + e.getMessage());
        }
        return matchAdded;
    }

    @Override
    public boolean userLogin(String userName, String password) throws RemoteException {
        if (userName == null || password == null) {
            return false;
        }
        boolean authenticated = false;
        try {
            boolean bl = authenticated = this.m_statement.executeUpdate("UPDATE UserData SET LastLogin = CURRENT_TIMESTAMP WHERE UserName = '" + userName + "' " + "AND Password = '" + password + "'") != 0;
            if (authenticated) {
                int i = 0;
                while (i < this.m_listeners.size()) {
                    try {
                        this.m_listeners.elementAt(i).userLogin(userName);
                    }
                    catch (RemoteException e) {
                        DatabaseServer.console.writeLine("Removing database listener: " + e.getMessage());
                        this.m_listeners.remove(i);
                        --i;
                    }
                    ++i;
                }
                DatabaseServer.console.writeLine("User \"" + userName + "\" logged in");
            } else {
                DatabaseServer.console.writeLine("User \"" + userName + "\" failed to login with valid credentials");
            }
            return authenticated;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error processing login request for user \"" + userName + "\": " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean userLogout(String userName) throws RemoteException {
        if (userName == null) {
            return false;
        }
        boolean loggedOut = false;
        try {
            boolean bl = loggedOut = this.m_statement.executeUpdate("UPDATE UserData SET LastLogin = CURRENT_TIMESTAMP WHERE UserName = '" + userName + "'") != 0;
            if (loggedOut) {
                int i = 0;
                while (i < this.m_listeners.size()) {
                    try {
                        this.m_listeners.elementAt(i).userLogout(userName);
                    }
                    catch (RemoteException e) {
                        DatabaseServer.console.writeLine("Removing database listener: " + e.getMessage());
                        this.m_listeners.remove(i);
                        --i;
                    }
                    ++i;
                }
                DatabaseServer.console.writeLine("User \"" + userName + "\" logged out");
            }
            return true;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error processing logout request for user \"" + userName + "\": " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean changePassword(String userName, String oldPassword, String newPassword) throws RemoteException {
        if (userName == null || oldPassword == null || newPassword == null) {
            return false;
        }
        boolean passwordChanged = false;
        try {
            boolean bl = passwordChanged = this.m_statement.executeUpdate("UPDATE UserData SET Password = '" + newPassword + "' " + "WHERE UserName = '" + userName + "' " + "AND Password = '" + oldPassword + "'") != 0;
            if (passwordChanged) {
                DatabaseServer.console.writeLine("Changed password for user \"" + userName + "\"");
            }
            return passwordChanged;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error changing password for user \"" + userName + "\": " + e.getMessage());
            return false;
        }
    }

    public boolean addGame(String firstPlayer, String secondPlayer, Outcome outcome) throws RemoteException {
        if (firstPlayer == null || secondPlayer == null || outcome == null) {
            return false;
        }
        boolean gameCreated = false;
        try {
            boolean bl = gameCreated = this.m_statement.executeUpdate("INSERT INTO GameHistory VAULES(CURRENT_TIMESTAMP, '" + firstPlayer + "', " + "'" + secondPlayer + "', " + "'" + outcome.ordinal() + "'" + ")") != 0;
            if (gameCreated) {
                DatabaseServer.console.writeLine("Added game beween \"" + firstPlayer + "\" and \"" + secondPlayer + "\" to database");
            }
            return gameCreated;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error adding game for users \"" + firstPlayer + "\" and \"" + secondPlayer + "\": " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] getPlayerStats(String userName) throws RemoteException {
        if (userName == null) {
            return null;
        }
        try {
            SQLResult users = new SQLResult(this.m_statement.executeQuery("SELECT * FROM UserData WHERE UserName = '" + userName + "'"));
            if (users.getRowCount() != 1) {
                return null;
            }
            int[] stats = new int[3];
            try {
                int i = 0;
                while (i < 3) {
                    stats[i] = Integer.parseInt(users.getElement(0, i + 4));
                    if (stats[i] < 0) {
                        return null;
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            DatabaseServer.console.writeLine("Retrieved stats for user \"" + userName + "\"");
            return stats;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error retrieving stats for user \"" + userName + "\": " + e.getMessage());
            return null;
        }
    }

    @Override
    public Vector<MatchData> getPlayerHistory(String playerName) throws RemoteException {
        if (playerName == null) {
            return null;
        }
        try {
            SQLResult result = new SQLResult(this.m_statement.executeQuery("SELECT * FROM GameHistory WHERE FirstPlayer = '" + playerName + "'" + "OR SecondPlayer = '" + playerName + "'"));
            Vector<MatchData> matchData = new Vector<MatchData>();
            if (result.getRowCount() == 0) {
                return matchData;
            }
            int i = 0;
            while (i < result.getRowCount()) {
                SQLResultRow r = result.getRow(i);
                matchData.add(new MatchData(r.elementAt(0), r.elementAt(1), r.elementAt(2), Outcome.values()[Integer.parseInt(r.elementAt(3))]));
                ++i;
            }
            DatabaseServer.console.writeLine("Retrieved match history for \"" + playerName + "\"");
            return matchData;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error retrieving player history for player \"" + playerName + "\": " + e.getMessage());
            return null;
        }
    }

    @Override
    public Vector<MatchData> getMatchHistory(String firstPlayerName, String secondPlayerName) throws RemoteException {
        if (firstPlayerName == null || secondPlayerName == null) {
            return null;
        }
        try {
            SQLResult result = new SQLResult(this.m_statement.executeQuery("SELECT * FROM GameHistory WHERE (FirstPlayer = '" + firstPlayerName + "'" + "AND " + "SecondPlayer = '" + secondPlayerName + "')" + "OR " + "(FirstPlayer = '" + secondPlayerName + "'" + "AND " + "SecondPlayer = '" + firstPlayerName + "')"));
            Vector<MatchData> matchData = new Vector<MatchData>();
            if (result.getRowCount() == 0) {
                return matchData;
            }
            int i = 0;
            while (i < result.getRowCount()) {
                SQLResultRow r = result.getRow(i);
                matchData.add(new MatchData(r.elementAt(0), r.elementAt(1), r.elementAt(2), Outcome.values()[Integer.parseInt(r.elementAt(3))]));
                ++i;
            }
            DatabaseServer.console.writeLine("Retrieved match history history for players \"" + firstPlayerName + "\" and \"" + secondPlayerName + "\"");
            return matchData;
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error retrieving player history for players \"" + firstPlayerName + "\" and \"" + secondPlayerName + "\": " + e.getMessage());
            return null;
        }
    }

    @Override
    public synchronized boolean addListener(DBMSListener listener) throws RemoteException {
        if (listener == null) {
            return false;
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
            DatabaseServer.console.writeLine("Adding database listener");
        }
        return true;
    }

    @Override
    public synchronized boolean removeListener(DBMSListener listener) throws RemoteException {
        if (listener == null) {
            return false;
        }
        if (this.m_listeners.remove(listener)) {
            DatabaseServer.console.writeLine("Removing database listener");
        }
        return true;
    }

    @Override
    public void close() throws RemoteException {
        this.m_initialized = false;
        try {
            SQLiteDBMS.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        try {
            this.m_database.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void notifyStatsUpdate(String userName) {
        if (userName == null) {
            return;
        }
        try {
            SQLResult users = new SQLResult(this.m_statement.executeQuery("SELECT * FROM UserData WHERE UserName = '" + userName + "'"));
            if (users.getRowCount() != 1) {
                return;
            }
            int wins = -1;
            int losses = -1;
            int draws = -1;
            try {
                wins = Integer.parseInt(users.getElement(0, 4));
                losses = Integer.parseInt(users.getElement(0, 5));
                draws = Integer.parseInt(users.getElement(0, 6));
            }
            catch (NumberFormatException e) {
                return;
            }
            if (wins < 0 || losses < 0 || draws < 0) {
                return;
            }
            int i = 0;
            while (i < this.m_listeners.size()) {
                try {
                    this.m_listeners.elementAt(i).statsUpdated(userName, wins, losses, draws);
                }
                catch (RemoteException e) {
                    DatabaseServer.console.writeLine("Removing database listener: " + e.getMessage());
                    this.m_listeners.remove(i);
                    --i;
                }
                ++i;
            }
            DatabaseServer.console.writeLine("Notified " + this.m_listeners.size() + " listeners of stats update for \"" + userName + "\"");
        }
        catch (SQLException e) {
            DatabaseServer.console.writeLine("Error retrieving user \"" + userName + "\" data for stats update: " + e.getMessage());
        }
    }

    @Override
    public void updateTable(String tableName, JTable table, boolean autoSizeColumns) {
        if (tableName == null || table == null) {
            return;
        }
        if (!tableName.equals(USER_DATA_TABLENAME) && !tableName.equals(GAME_HISTORY_TABLENAME)) {
            return;
        }
        try {
            int x = table.getSelectedColumn();
            int y = table.getSelectedRow();
            DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
            tableModel.getDataVector().removeAllElements();
            tableModel.fireTableDataChanged();
            ResultSet result = this.m_statement.executeQuery("SELECT * FROM " + tableName);
            ResultSetMetaData metaData = result.getMetaData();
            int numberOfColumns = metaData.getColumnCount();
            while (result.next()) {
                Object[] rowData = new String[numberOfColumns];
                int i = 1;
                while (i <= numberOfColumns) {
                    rowData[i - 1] = result.getString(i);
                    ++i;
                }
                tableModel.addRow(rowData);
            }
            if (x >= 0 && y >= 0 && x < table.getColumnCount() && y < table.getRowCount()) {
                table.getSelectionModel().setSelectionInterval(y, y);
                table.getColumnModel().getSelectionModel().setSelectionInterval(x, x);
            }
            if (autoSizeColumns) {
                TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
                int i = 0;
                while (i < table.getColumnCount()) {
                    table.getColumnModel().getColumn(i).setPreferredWidth(renderer.getTableCellRendererComponent((JTable)table, (Object)table.getModel().getColumnName((int)i), (boolean)false, (boolean)false, (int)0, (int)i).getPreferredSize().width);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

