/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.regex.Pattern;

public class ExtendedClassLoader
extends ClassLoader {
    public ExtendedClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public ExtendedClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    @Override
    public synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        c = this.findLoadedClass(className);
        if (c != null) {
            return c;
        }
        try {
            c = this.findSystemClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c != null) {
            return c;
        }
        c = this.findClass(className);
        return c;
    }

    public byte[] serializeClass(String className) {
        File f;
        byte[] data;
        block8: {
            if (className == null) {
                return null;
            }
            data = null;
            String path = className.trim();
            if (!Pattern.compile(".*\\.class$", 2).matcher(path).matches()) {
                path = String.valueOf(path) + ".class";
            }
            int numberOfPeriods = 0;
            int i = 0;
            while (i < path.length()) {
                if (path.charAt(i) == '.') {
                    ++numberOfPeriods;
                }
                ++i;
            }
            String[] temp = path.split("[\\.]{1}", numberOfPeriods);
            path = "bin";
            int i2 = 0;
            while (i2 < temp.length) {
                path = String.valueOf(path) + "/" + temp[i2];
                ++i2;
            }
            try {
                f = new File(path);
                if (f.exists()) break block8;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        DataInputStream in = new DataInputStream(new FileInputStream(f));
        data = new byte[(int)f.length()];
        in.readFully(data);
        in.close();
        return data;
    }

    public Class<?> deserializeClass(String name, byte[] classData) {
        return this.deserializeClass(name, classData, true);
    }

    public Class<?> deserializeClass(String name, byte[] classData, boolean resolve) {
        Class<?> c;
        if (name == null || classData == null) {
            return null;
        }
        try {
            c = this.loadClass(name);
            if (c == null) {
                c = this.defineClass(name, classData, 0, classData.length);
            }
            if (resolve) {
                this.resolveClass(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return c;
    }
}

