/*
 * Decompiled with CFR 0.152.
 */
package palette;

import exception.PaletteReadException;
import exception.PaletteWriteException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import palette.Palette;
import utilities.Utilities;

public class PaletteImage
extends Palette {
    protected BufferedImage m_image = null;
    protected int m_scale = 1;
    public static final String[] FILE_TYPES = new String[]{"PNG", "GIF", "BMP"};
    public static final String PALETTE_DESCRIPTION = "Default";

    public PaletteImage() {
        this(null);
    }

    public PaletteImage(File file) {
        super(file);
    }

    public String getType() {
        return "Image";
    }

    public int numberOfFileTypes() {
        return FILE_TYPES.length;
    }

    public String getFileType(int n) {
        if (n < 0 || n >= FILE_TYPES.length) {
            return null;
        }
        return FILE_TYPES[n];
    }

    public int indexOfFileType(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        for (int i = 0; i < FILE_TYPES.length; ++i) {
            if (!FILE_TYPES[i].equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    public BufferedImage getImage() {
        return this.m_image;
    }

    public int getScale() {
        return this.m_scale;
    }

    public String getPaletteDescription(int n) {
        return n == 0 ? PALETTE_DESCRIPTION : null;
    }

    public Color getPixel(int n, int n2, int n3) {
        if (!this.m_loaded || n2 < 0 || n3 < 0 || n2 > 15 || n3 > 15 || n != 0) {
            return null;
        }
        return new Color(this.m_image.getRGB(n2 * this.m_scale, n3 * this.m_scale));
    }

    public boolean updatePixel(int n, int n2, Color color, int n3) {
        if (!this.m_loaded || this.m_image == null || color == null || n < 0 || n2 < 0 || n > 15 || n2 > 15 || n3 != 0) {
            return false;
        }
        this.m_image.setRGB(n, n2, color.getRGB());
        return true;
    }

    public Color[] getColourData(int n) {
        if (n != 0 || !this.m_loaded || this.m_image == null) {
            return null;
        }
        Color[] colorArray = new Color[256];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                colorArray[i * 16 + j] = this.getPixel(j, i);
            }
        }
        return colorArray;
    }

    public boolean updateColourData(int n, int n2, Color[] colorArray) {
        if (n != 0) {
            return false;
        }
        int n3 = n2 * 256;
        if (colorArray.length - n3 < 256) {
            return false;
        }
        if (!this.m_loaded || this.m_scale != 1) {
            if (this.isInstantiable()) {
                this.m_scale = 1;
                this.m_image = new BufferedImage(16, 16, 1);
                this.m_loaded = true;
            } else {
                return false;
            }
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.m_image.setRGB(j, i, colorArray[n3 + i * 16 + j].getRGB());
            }
        }
        return true;
    }

    public boolean fillWithColour(Color color, int n) {
        if (n > 0) {
            return false;
        }
        if (!this.m_loaded || this.m_scale != 1) {
            if (this.isInstantiable()) {
                this.m_scale = 1;
                this.m_image = new BufferedImage(16, 16, 1);
                this.m_loaded = true;
            } else {
                return false;
            }
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.m_image.setRGB(j, i, color.getRGB());
            }
        }
        return true;
    }

    public boolean load() throws PaletteReadException {
        if (this.m_file == null || !this.m_file.exists()) {
            return false;
        }
        String string = Utilities.getFileExtension((String)this.m_file.getName());
        if (string == null) {
            throw new PaletteReadException("File " + this.m_file.getName() + " has no extension.");
        }
        if (!this.hasFileType(string)) {
            throw new PaletteReadException("File " + this.m_file.getName() + " has unsupported extension: " + string);
        }
        try {
            this.m_image = ImageIO.read(this.m_file);
        }
        catch (IOException iOException) {
            throw new PaletteReadException("ImageIO failed to load image: " + this.m_file.getName());
        }
        if (this.m_image == null) {
            throw new PaletteReadException("Null image returned, ImageIO failed to load image: " + this.m_file.getName());
        }
        if (this.m_image.getWidth() != this.m_image.getHeight()) {
            throw new PaletteReadException("Palette image \"" + this.m_file.getName() + "\" must be square.");
        }
        if (this.m_image.getWidth() < 16 || this.m_image.getHeight() < 16) {
            throw new PaletteReadException("Palette image \"" + this.m_file.getName() + "\" dimensions must be at least " + 16 + " x " + 16 + ".");
        }
        if (this.m_image.getWidth() % 16 != 0 || this.m_image.getHeight() % 16 != 0) {
            throw new PaletteReadException("Palette image \"" + this.m_file.getName() + "\" dimensions must be a multiple of " + 16 + ".");
        }
        this.m_scale = this.m_image.getWidth() / 16;
        this.m_loaded = true;
        return true;
    }

    public boolean save(String string) throws PaletteWriteException {
        if (!this.m_loaded || this.m_file == null) {
            throw new PaletteWriteException("Palette image file must be loaded and initialized with a file to be saved.");
        }
        String string2 = null;
        string2 = string == null ? this.getDefaultFileType() : string.trim();
        if (!this.hasFileType(string2)) {
            throw new PaletteWriteException("Image palette file type \"" + string2 + "\" is not supported for writing.");
        }
        try {
            return ImageIO.write((RenderedImage)this.m_image, string2.toLowerCase(), this.m_file);
        }
        catch (IOException iOException) {
            throw new PaletteWriteException("Failed to save palette image to file: \"" + this.m_file.getName() + "\".");
        }
    }
}

