/*
 * Decompiled with CFR 0.152.
 */
package palette;

import exception.PaletteReadException;
import exception.PaletteWriteException;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import palette.DATType;
import palette.Palette;
import utilities.Utilities;

public class PaletteDAT
extends Palette {
    protected byte[] m_data = null;
    protected DATType m_type = DATType.Unknown;
    public static final int BPP = 3;
    public static final int COLOUR_SCALE = 4;
    public static final int[] PALETTE_OFFSET = new int[]{0, 6426};
    public static final int PALETTE_SIZE_RGB = 768;
    public static final int[] NUMBER_OF_DAT_PALETTES = new int[]{1, 5};
    public static final String PALETTE_DAT_DESCRIPTION = "Normal";
    public static final String[] LOOKUP_DAT_DESCRIPTION = new String[]{"Underwater", "Night Vision", "Title Screen", "3D Realms Logo", "Episode 1 Ending Animation"};
    public static final String FILE_TYPE = "DAT";

    public PaletteDAT() {
        this(null);
    }

    public PaletteDAT(File file) {
        super(file);
    }

    public int numberOfFileTypes() {
        return 1;
    }

    public String getFileType(int n) {
        return n == 0 ? FILE_TYPE : null;
    }

    public int indexOfFileType(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return -1;
        }
        return FILE_TYPE.equalsIgnoreCase(string2) ? 0 : -1;
    }

    public int numberOfPalettes() {
        return this.m_type == DATType.Unknown ? -1 : NUMBER_OF_DAT_PALETTES[this.m_type.ordinal()];
    }

    public String getPaletteDescription(int n) {
        if (n < 0 || n >= this.numberOfPalettes()) {
            return null;
        }
        if (this.m_type == DATType.Palette) {
            return PALETTE_DAT_DESCRIPTION;
        }
        if (this.m_type == DATType.Lookup) {
            return LOOKUP_DAT_DESCRIPTION[n];
        }
        return null;
    }

    public boolean isInstantiable() {
        return false;
    }

    public DATType getDATType() {
        return this.m_type;
    }

    public Color getPixel(int n, int n2, int n3) {
        if (!this.m_loaded || n2 < 0 || n3 < 0 || n2 > 15 || n3 > 15 || n < 0 || n >= this.numberOfPalettes()) {
            return null;
        }
        int n4 = PALETTE_OFFSET[this.m_type.ordinal()] + n * 768 + n3 * 16 * 3 + n2 * 3;
        int n5 = (this.m_data[n4] & 0xFF) * 4;
        int n6 = (this.m_data[n4 + 1] & 0xFF) * 4;
        int n7 = (this.m_data[n4 + 2] & 0xFF) * 4;
        if (n5 < 0 || n5 > 255) {
            System.out.println("Red channel exceeded 0-255 boundary in DAT file \"" + this.m_file.getName() + "\" with value: " + n5 + " at offset: " + n4);
        }
        if (n6 < 0 || n6 > 255) {
            System.out.println("Green channel exceeded 0-255 boundary in DAT file \"" + this.m_file.getName() + "\" with value: " + n6 + " at offset: " + n4 + 1);
        }
        if (n7 < 0 || n7 > 255) {
            System.out.println("Blue channel exceeded 0-255 boundary in DAT file \"" + this.m_file.getName() + "\" with value: " + n7 + " at offset: " + n4 + 2);
        }
        return new Color(n5 < 0 ? 0 : (n5 > 255 ? 255 : n5), n6 < 0 ? 0 : (n6 > 255 ? 255 : n6), n7 < 0 ? 0 : (n7 > 255 ? 255 : n7));
    }

    public boolean updatePixel(int n, int n2, Color color, int n3) {
        if (!this.m_loaded || this.m_data == null || color == null || n < 0 || n2 < 0 || n > 15 || n2 > 15 || n3 < 0 || n3 >= this.numberOfPalettes()) {
            return false;
        }
        int n4 = PALETTE_OFFSET[this.m_type.ordinal()] + n3 * 768 + n2 * 16 * 3 + n * 3;
        this.m_data[n4] = (byte)(color.getRed() / 4);
        this.m_data[n4 + 1] = (byte)(color.getGreen() / 4);
        this.m_data[n4 + 2] = (byte)(color.getBlue() / 4);
        return true;
    }

    public Color[] getColourData(int n) {
        if (!this.m_loaded || this.m_data == null || this.m_type == DATType.Unknown || n < 0 || n >= this.numberOfPalettes()) {
            return null;
        }
        Color[] colorArray = new Color[256];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                colorArray[i * 16 + j] = this.getPixel(n, j, i);
            }
        }
        return colorArray;
    }

    public Color[] getAllColourData() {
        if (!this.m_loaded || this.m_data == null || this.m_type == DATType.Unknown) {
            return null;
        }
        Color[] colorArray = new Color[256 * this.numberOfPalettes()];
        for (int i = 0; i < this.numberOfPalettes(); ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    colorArray[i * 256 + j * 16 + k] = this.getPixel(i, k, j);
                }
            }
        }
        return colorArray;
    }

    public boolean updateColourData(int n, int n2, Color[] colorArray) {
        if (!this.m_loaded || this.m_data == null || this.m_type == DATType.Unknown) {
            return false;
        }
        int n3 = n2 * 256;
        if (colorArray.length - n3 < 256) {
            return false;
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                n4 = PALETTE_OFFSET[this.m_type.ordinal()] + n * 768 + i * 16 * 3 + j * 3;
                n5 = n3 + i * 16 + j;
                this.m_data[n4] = (byte)(colorArray[n5].getRed() / 4);
                this.m_data[n4 + 1] = (byte)(colorArray[n5].getGreen() / 4);
                this.m_data[n4 + 2] = (byte)(colorArray[n5].getBlue() / 4);
            }
        }
        return true;
    }

    public boolean updateAllColourData(Color[] colorArray) {
        if (!this.m_loaded || this.m_data == null || this.m_type == DATType.Unknown) {
            return false;
        }
        if (colorArray.length < 256 * this.numberOfPalettes()) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.numberOfPalettes(); ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    n = PALETTE_OFFSET[this.m_type.ordinal()] + i * 768 + j * 16 * 3 + k * 3;
                    n2 = i * 256 + j * 16 + k;
                    this.m_data[n] = (byte)(colorArray[n2].getRed() / 4);
                    this.m_data[n + 1] = (byte)(colorArray[n2].getGreen() / 4);
                    this.m_data[n + 2] = (byte)(colorArray[n2].getBlue() / 4);
                }
            }
        }
        return true;
    }

    public boolean fillWithColour(Color color, int n) {
        if (!this.m_loaded || this.m_data == null || this.m_type == DATType.Unknown || color == null) {
            return false;
        }
        int n2 = 0;
        for (int i = n < 0 ? 0 : n; i < (n < 0 ? n + 1 : this.numberOfPalettes()); ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    n2 = PALETTE_OFFSET[this.m_type.ordinal()] + i * 768 + j * 16 * 3 + k * 3;
                    this.m_data[n2] = (byte)(color.getRed() / 4);
                    this.m_data[n2 + 1] = (byte)(color.getGreen() / 4);
                    this.m_data[n2 + 2] = (byte)(color.getBlue() / 4);
                }
            }
        }
        return true;
    }

    public boolean load() throws PaletteReadException {
        Object object;
        Object object2;
        if (this.m_file == null || !this.m_file.exists()) {
            return false;
        }
        String string = Utilities.getFileNameNoExtension((String)this.m_file.getName());
        String string2 = Utilities.getFileExtension((String)this.m_file.getName());
        if (string == null) {
            throw new PaletteReadException("Unable to determine filename for file: \"" + this.m_file.getName() + "\".");
        }
        if (string2 == null) {
            throw new PaletteReadException("File \"" + this.m_file.getName() + "\" has no extension.");
        }
        if (!string2.equalsIgnoreCase(FILE_TYPE)) {
            throw new PaletteReadException("File \"" + this.m_file.getName() + "\" is not a valid " + FILE_TYPE + " file.");
        }
        this.m_type = DATType.parseFrom(string);
        if (this.m_type == DATType.Unknown) {
            object2 = new String[DATType.Unknown.ordinal()];
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object2[i] = DATType.getDisplayName(DATType.values()[i]);
            }
            object = JOptionPane.showInputDialog(null, "Unable to determine DAT type.\nPlease choose a DAT type from the list:", "Identify DAT Type", 3, null, (Object[])object2, object2[0]);
            if (object == null) {
                return false;
            }
            for (int i = 0; i < ((Object)object2).length; ++i) {
                if (object2[i] != object) continue;
                this.m_type = DATType.values()[i];
                break;
            }
        }
        if (this.m_file.length() > Integer.MAX_VALUE) {
            throw new PaletteReadException("File \"" + this.m_file.getName() + "\" is too large to store in memory.");
        }
        object2 = null;
        object = new byte[(int)this.m_file.length()];
        try {
            object2 = new FileInputStream(this.m_file);
            ((InputStream)object2).read((byte[])object);
            ((InputStream)object2).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PaletteReadException("File \"" + this.m_file.getName() + "\" not found.");
        }
        catch (IOException iOException) {
            throw new PaletteReadException("Error reading file \"" + this.m_file.getName() + "\": " + iOException.getMessage());
        }
        this.m_data = object;
        this.m_loaded = true;
        return true;
    }

    public boolean save(String string) throws PaletteWriteException {
        if (!this.m_loaded || this.m_file == null) {
            throw new PaletteWriteException("Palette DAT file must be loaded and initialized with a file to be saved.");
        }
        String string2 = null;
        string2 = string == null ? this.getDefaultFileType() : string.trim();
        if (!this.hasFileType(string2)) {
            throw new PaletteWriteException("DAT palette file type \"" + string2 + "\" is not supported for writing.");
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.m_file));
            ((OutputStream)bufferedOutputStream).write(this.m_data);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PaletteWriteException("File " + this.m_file.getName() + " not found.");
        }
        catch (IOException iOException) {
            throw new PaletteWriteException("Error writing to file " + this.m_file.getName() + ": " + iOException.getMessage());
        }
        return true;
    }
}

