/*
 * Decompiled with CFR 0.152.
 */
package gui;

import exception.PaletteInstantiationException;
import exception.PaletteReadException;
import exception.PaletteWriteException;
import gui.PalettePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import palette.Palette;
import palette.PaletteEditor;
import palette.PalettePlugin;
import utilities.Updatable;
import utilities.Utilities;
import version.VersionChecker;

public class PaletteEditorWindow
implements WindowListener,
ComponentListener,
ChangeListener,
ActionListener,
Updatable {
    private JFrame m_frame;
    private JTabbedPane m_mainTabbedPane;
    private Vector<PalettePanel> m_palettePanels;
    private JTextArea m_consoleText;
    private Font m_consoleFont;
    private JScrollPane m_consoleScrollPane;
    private JMenuBar m_menuBar;
    private JMenu m_fileMenu;
    private JMenuItem m_fileNewMenuItem;
    private JMenuItem m_fileOpenMenuItem;
    private JMenuItem m_fileSaveMenuItem;
    private JMenuItem m_fileSaveAsMenuItem;
    private JMenuItem m_fileSaveAllMenuItem;
    private JMenuItem m_fileImportMenuItem;
    private JMenuItem m_fileExportMenuItem;
    private JMenuItem m_fileCloseMenuItem;
    private JMenuItem m_fileCloseAllMenuItem;
    private JMenuItem m_fileExitMenuItem;
    private JMenu m_settingsMenu;
    private JMenuItem m_settingsPluginDirectoryNameMenuItem;
    private JMenuItem m_settingsConsoleLogFileNameMenuItem;
    private JMenuItem m_settingsLogDirectoryNameMenuItem;
    private JMenuItem m_settingsVersionFileURLMenuItem;
    private JMenuItem m_settingsBackgroundColourMenuItem;
    private JCheckBoxMenuItem m_settingsAutoScrollConsoleMenuItem;
    private JMenuItem m_settingsMaxConsoleHistoryMenuItem;
    private JCheckBoxMenuItem m_settingsLogConsoleMenuItem;
    private JCheckBoxMenuItem m_settingsSupressUpdatesMenuItem;
    private JCheckBoxMenuItem m_settingsAutoSaveSettingsMenuItem;
    private JMenuItem m_settingsSaveSettingsMenuItem;
    private JMenuItem m_settingsReloadSettingsMenuItem;
    private JMenuItem m_settingsResetSettingsMenuItem;
    private JMenu m_pluginsMenu;
    private JMenuItem m_pluginsListLoadedMenuItem;
    private JMenuItem m_pluginsLoadMenuItem;
    private JMenuItem m_pluginsLoadAllMenuItem;
    private JCheckBoxMenuItem m_pluginsAutoLoadMenuItem;
    private JMenu m_windowMenu;
    private JMenuItem m_buttonSizeMenuItem;
    private JMenuItem m_paletteSpacingMenuItem;
    private JMenuItem m_windowResetPositionMenuItem;
    private JMenuItem m_windowResetSizeMenuItem;
    private JMenu m_helpMenu;
    private JMenuItem m_helpCheckVersionMenuItem;
    private JMenuItem m_helpAboutMenuItem;
    private boolean m_initialized;
    private boolean m_updating;
    public static final int SCROLL_INCREMENT = 16;
    private TransferHandler m_transferHandler = new TransferHandler(){
        private static final long serialVersionUID = 7382995584179254438L;

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            transferSupport.setDropAction(1);
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                PaletteEditorWindow.this.loadPalettes(((List)transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)).toArray(new File[1]));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
    };

    public PaletteEditorWindow() {
        this.m_frame = new JFrame("Palette Editor Window");
        this.m_frame.setDefaultCloseOperation(0);
        this.m_frame.setMinimumSize(new Dimension(320, 240));
        this.m_frame.setLocation(0, 0);
        this.m_frame.setSize(800, 600);
        this.m_frame.addWindowListener(this);
        this.m_frame.addComponentListener(this);
        this.m_frame.setTransferHandler(this.m_transferHandler);
        this.m_palettePanels = new Vector();
        this.m_initialized = false;
        this.m_updating = false;
        this.initMenu();
        this.initComponents();
        this.update();
    }

    public boolean initialize() {
        if (this.m_initialized) {
            return false;
        }
        this.updateWindow();
        this.m_frame.setLocation(PaletteEditor.settings.windowPositionX, PaletteEditor.settings.windowPositionY);
        this.m_frame.setSize(PaletteEditor.settings.windowWidth, PaletteEditor.settings.windowHeight);
        this.update();
        this.m_frame.setVisible(true);
        this.m_initialized = true;
        this.update();
        return true;
    }

    private void initMenu() {
        this.m_menuBar = new JMenuBar();
        this.m_fileMenu = new JMenu("File");
        this.m_fileNewMenuItem = new JMenuItem("New");
        this.m_fileOpenMenuItem = new JMenuItem("Open");
        this.m_fileSaveMenuItem = new JMenuItem("Save");
        this.m_fileSaveAsMenuItem = new JMenuItem("Save As");
        this.m_fileSaveAllMenuItem = new JMenuItem("Save All");
        this.m_fileImportMenuItem = new JMenuItem("Import");
        this.m_fileExportMenuItem = new JMenuItem("Export");
        this.m_fileCloseMenuItem = new JMenuItem("Close");
        this.m_fileCloseAllMenuItem = new JMenuItem("Close All");
        this.m_fileExitMenuItem = new JMenuItem("Exit");
        this.m_fileNewMenuItem.setMnemonic('N');
        this.m_fileOpenMenuItem.setMnemonic('O');
        this.m_fileSaveMenuItem.setMnemonic('S');
        this.m_fileImportMenuItem.setMnemonic('I');
        this.m_fileExportMenuItem.setMnemonic('E');
        this.m_fileNewMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.m_fileOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.m_fileSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.m_fileImportMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.m_fileExportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.m_settingsMenu = new JMenu("Settings");
        this.m_settingsPluginDirectoryNameMenuItem = new JMenuItem("Plugin Directory Name");
        this.m_settingsConsoleLogFileNameMenuItem = new JMenuItem("Console Log File Name");
        this.m_settingsLogDirectoryNameMenuItem = new JMenuItem("Log Directory Name");
        this.m_settingsVersionFileURLMenuItem = new JMenuItem("Version File URL");
        this.m_settingsBackgroundColourMenuItem = new JMenuItem("Background Colour");
        this.m_settingsAutoScrollConsoleMenuItem = new JCheckBoxMenuItem("Auto-Scroll Console");
        this.m_settingsMaxConsoleHistoryMenuItem = new JMenuItem("Max Console History");
        this.m_settingsLogConsoleMenuItem = new JCheckBoxMenuItem("Log Console");
        this.m_settingsSupressUpdatesMenuItem = new JCheckBoxMenuItem("Supress Update Notifications");
        this.m_settingsAutoSaveSettingsMenuItem = new JCheckBoxMenuItem("Auto-Save Settings");
        this.m_settingsSaveSettingsMenuItem = new JMenuItem("Save Settings");
        this.m_settingsReloadSettingsMenuItem = new JMenuItem("Reload Settings");
        this.m_settingsResetSettingsMenuItem = new JMenuItem("Reset Settings");
        this.m_settingsAutoScrollConsoleMenuItem.setSelected(true);
        this.m_settingsAutoSaveSettingsMenuItem.setSelected(true);
        this.m_settingsLogConsoleMenuItem.setSelected(false);
        this.m_settingsSupressUpdatesMenuItem.setSelected(false);
        this.m_pluginsMenu = new JMenu("Plugins");
        this.m_pluginsListLoadedMenuItem = new JMenuItem("List Loaded Plugins");
        this.m_pluginsLoadMenuItem = new JMenuItem("Load Plugin");
        this.m_pluginsLoadAllMenuItem = new JMenuItem("Load All Plugins");
        this.m_pluginsAutoLoadMenuItem = new JCheckBoxMenuItem("Auto-Load Plugins");
        this.m_pluginsAutoLoadMenuItem.setSelected(true);
        this.m_windowMenu = new JMenu("Window");
        this.m_buttonSizeMenuItem = new JMenuItem("Pixel Button Size");
        this.m_paletteSpacingMenuItem = new JMenuItem("Palette Spacing");
        this.m_windowResetPositionMenuItem = new JMenuItem("Reset Window Position");
        this.m_windowResetSizeMenuItem = new JMenuItem("Reset Window Size");
        this.m_helpMenu = new JMenu("Help");
        this.m_helpCheckVersionMenuItem = new JMenuItem("Check for Updates");
        this.m_helpAboutMenuItem = new JMenuItem("About");
        this.m_fileNewMenuItem.addActionListener(this);
        this.m_fileOpenMenuItem.addActionListener(this);
        this.m_fileSaveMenuItem.addActionListener(this);
        this.m_fileSaveAsMenuItem.addActionListener(this);
        this.m_fileSaveAllMenuItem.addActionListener(this);
        this.m_fileImportMenuItem.addActionListener(this);
        this.m_fileExportMenuItem.addActionListener(this);
        this.m_fileCloseMenuItem.addActionListener(this);
        this.m_fileCloseAllMenuItem.addActionListener(this);
        this.m_fileExitMenuItem.addActionListener(this);
        this.m_settingsPluginDirectoryNameMenuItem.addActionListener(this);
        this.m_settingsConsoleLogFileNameMenuItem.addActionListener(this);
        this.m_settingsLogDirectoryNameMenuItem.addActionListener(this);
        this.m_settingsVersionFileURLMenuItem.addActionListener(this);
        this.m_settingsBackgroundColourMenuItem.addActionListener(this);
        this.m_settingsAutoScrollConsoleMenuItem.addActionListener(this);
        this.m_settingsMaxConsoleHistoryMenuItem.addActionListener(this);
        this.m_settingsLogConsoleMenuItem.addActionListener(this);
        this.m_settingsSupressUpdatesMenuItem.addActionListener(this);
        this.m_settingsAutoSaveSettingsMenuItem.addActionListener(this);
        this.m_settingsSaveSettingsMenuItem.addActionListener(this);
        this.m_settingsReloadSettingsMenuItem.addActionListener(this);
        this.m_settingsResetSettingsMenuItem.addActionListener(this);
        this.m_pluginsListLoadedMenuItem.addActionListener(this);
        this.m_pluginsLoadMenuItem.addActionListener(this);
        this.m_pluginsLoadAllMenuItem.addActionListener(this);
        this.m_pluginsAutoLoadMenuItem.addActionListener(this);
        this.m_buttonSizeMenuItem.addActionListener(this);
        this.m_paletteSpacingMenuItem.addActionListener(this);
        this.m_windowResetPositionMenuItem.addActionListener(this);
        this.m_windowResetSizeMenuItem.addActionListener(this);
        this.m_helpCheckVersionMenuItem.addActionListener(this);
        this.m_helpAboutMenuItem.addActionListener(this);
        this.m_fileMenu.add(this.m_fileNewMenuItem);
        this.m_fileMenu.add(this.m_fileOpenMenuItem);
        this.m_fileMenu.add(this.m_fileSaveMenuItem);
        this.m_fileMenu.add(this.m_fileSaveAsMenuItem);
        this.m_fileMenu.add(this.m_fileSaveAllMenuItem);
        this.m_fileMenu.add(this.m_fileImportMenuItem);
        this.m_fileMenu.add(this.m_fileExportMenuItem);
        this.m_fileMenu.add(this.m_fileCloseMenuItem);
        this.m_fileMenu.add(this.m_fileCloseAllMenuItem);
        this.m_fileMenu.add(this.m_fileExitMenuItem);
        this.m_settingsMenu.add(this.m_settingsPluginDirectoryNameMenuItem);
        this.m_settingsMenu.add(this.m_settingsConsoleLogFileNameMenuItem);
        this.m_settingsMenu.add(this.m_settingsLogDirectoryNameMenuItem);
        this.m_settingsMenu.add(this.m_settingsVersionFileURLMenuItem);
        this.m_settingsMenu.add(this.m_settingsBackgroundColourMenuItem);
        this.m_settingsMenu.add(this.m_settingsAutoScrollConsoleMenuItem);
        this.m_settingsMenu.add(this.m_settingsMaxConsoleHistoryMenuItem);
        this.m_settingsMenu.add(this.m_settingsLogConsoleMenuItem);
        this.m_settingsMenu.add(this.m_settingsSupressUpdatesMenuItem);
        this.m_settingsMenu.addSeparator();
        this.m_settingsMenu.add(this.m_settingsAutoSaveSettingsMenuItem);
        this.m_settingsMenu.add(this.m_settingsSaveSettingsMenuItem);
        this.m_settingsMenu.add(this.m_settingsReloadSettingsMenuItem);
        this.m_settingsMenu.add(this.m_settingsResetSettingsMenuItem);
        this.m_pluginsMenu.add(this.m_pluginsListLoadedMenuItem);
        this.m_pluginsMenu.add(this.m_pluginsLoadMenuItem);
        this.m_pluginsMenu.add(this.m_pluginsLoadAllMenuItem);
        this.m_pluginsMenu.add(this.m_pluginsAutoLoadMenuItem);
        this.m_windowMenu.add(this.m_buttonSizeMenuItem);
        this.m_windowMenu.add(this.m_paletteSpacingMenuItem);
        this.m_windowMenu.add(this.m_windowResetPositionMenuItem);
        this.m_windowMenu.add(this.m_windowResetSizeMenuItem);
        this.m_helpMenu.add(this.m_helpCheckVersionMenuItem);
        this.m_helpMenu.add(this.m_helpAboutMenuItem);
        this.m_menuBar.add(this.m_fileMenu);
        this.m_menuBar.add(this.m_settingsMenu);
        this.m_menuBar.add(this.m_pluginsMenu);
        this.m_menuBar.add(this.m_windowMenu);
        this.m_menuBar.add(this.m_helpMenu);
        this.m_frame.setJMenuBar(this.m_menuBar);
    }

    private void initComponents() {
        this.m_mainTabbedPane = new JTabbedPane();
        this.m_consoleText = new JTextArea();
        this.m_consoleFont = new Font("Verdana", 0, 14);
        this.m_consoleText.setFont(this.m_consoleFont);
        this.m_consoleText.setEditable(false);
        this.m_consoleText.setTransferHandler(this.m_transferHandler);
        this.m_consoleScrollPane = new JScrollPane(this.m_consoleText);
        this.m_mainTabbedPane.add(this.m_consoleScrollPane);
        this.m_mainTabbedPane.addTab("Console", null, this.m_consoleScrollPane, "Displays debugging information from the application.");
        this.m_mainTabbedPane.addChangeListener(this);
        this.m_frame.add(this.m_mainTabbedPane);
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public TransferHandler getTransferHandler() {
        return this.m_transferHandler;
    }

    public void addPalette(PalettePanel palettePanel) {
        if (palettePanel == null) {
            return;
        }
        palettePanel.setTransferHandler(this.m_transferHandler);
        palettePanel.addPaletteChangeListener(PaletteEditor.instance);
        this.m_palettePanels.add(palettePanel);
        JScrollPane jScrollPane = new JScrollPane(palettePanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        int n = this.m_mainTabbedPane.getTabCount() - 1;
        this.m_mainTabbedPane.insertTab(palettePanel.getTabName(), null, jScrollPane, palettePanel.getTabDescription(), n);
        this.m_mainTabbedPane.setSelectedIndex(n);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PaletteEditorWindow.this.m_mainTabbedPane.revalidate();
                PaletteEditorWindow.this.update();
            }
        });
    }

    public boolean unsavedChanges() {
        for (int i = 0; i < this.m_palettePanels.size(); ++i) {
            if (!this.m_palettePanels.elementAt(i).isChanged()) continue;
            return true;
        }
        return false;
    }

    protected boolean selectPalettePanel(PalettePanel palettePanel) {
        if (palettePanel == null) {
            return false;
        }
        PalettePanel palettePanel2 = null;
        for (int i = 0; i < this.m_mainTabbedPane.getComponentCount(); ++i) {
            palettePanel2 = this.getPalettePanelFrom(this.m_mainTabbedPane.getComponent(i));
            if (palettePanel2 == null || palettePanel != palettePanel2) continue;
            this.m_mainTabbedPane.setSelectedComponent(this.m_mainTabbedPane.getComponent(i));
            return true;
        }
        return false;
    }

    protected PalettePanel getSelectedPalettePanel() {
        Component component = this.m_mainTabbedPane.getSelectedComponent();
        if (component == null || !(component instanceof JScrollPane)) {
            return null;
        }
        JScrollPane jScrollPane = (JScrollPane)component;
        JViewport jViewport = jScrollPane.getViewport();
        if (jViewport == null || jViewport.getComponentCount() < 1) {
            return null;
        }
        Component component2 = jViewport.getComponent(0);
        if (component2 == null || !(component2 instanceof PalettePanel)) {
            return null;
        }
        return (PalettePanel)component2;
    }

    protected PalettePanel getPalettePanelFrom(Component component) {
        if (component == null || !(component instanceof JScrollPane)) {
            return null;
        }
        JScrollPane jScrollPane = (JScrollPane)component;
        JViewport jViewport = jScrollPane.getViewport();
        if (jViewport == null || jViewport.getComponentCount() < 1) {
            return null;
        }
        Component component2 = jViewport.getComponent(0);
        if (component2 == null || !(component2 instanceof PalettePanel)) {
            return null;
        }
        return (PalettePanel)component2;
    }

    protected Component getTabComponentWith(PalettePanel palettePanel) {
        if (palettePanel == null) {
            return null;
        }
        Component component = null;
        for (int i = 0; i < this.m_mainTabbedPane.getComponentCount(); ++i) {
            Component component2;
            JScrollPane jScrollPane;
            JViewport jViewport;
            component = this.m_mainTabbedPane.getComponent(i);
            if (!(component instanceof JScrollPane) || (jViewport = (jScrollPane = (JScrollPane)component).getViewport()) == null || jViewport.getComponentCount() < 1 || (component2 = jViewport.getComponent(0)) == null || !(component2 instanceof PalettePanel) || (PalettePanel)component2 != palettePanel) continue;
            return component;
        }
        return null;
    }

    protected int indexOfTabComponentWith(PalettePanel palettePanel) {
        if (palettePanel == null) {
            return -1;
        }
        Component component = null;
        for (int i = 0; i < this.m_mainTabbedPane.getComponentCount(); ++i) {
            Component component2;
            JScrollPane jScrollPane;
            JViewport jViewport;
            component = this.m_mainTabbedPane.getComponent(i);
            if (!(component instanceof JScrollPane) || (jViewport = (jScrollPane = (JScrollPane)component).getViewport()) == null || jViewport.getComponentCount() < 1 || (component2 = jViewport.getComponent(0)) == null || !(component2 instanceof PalettePanel) || component2 != palettePanel) continue;
            this.m_mainTabbedPane.indexOfComponent(component2);
        }
        return -1;
    }

    public boolean promptNewPalette() {
        Vector<PalettePlugin> vector = PaletteEditor.pluginManager.getLoadedInstantiablePlugins();
        if (vector.size() == 0) {
            PaletteEditor.console.writeLine("No palette plugins found that support instantiation. Perhaps you forgot to load all plugins?");
            JOptionPane.showMessageDialog(this.m_frame, "No palette plugins found that support instantiation. Perhaps you forgot to load all plugins?", "No Plugins", 0);
            return false;
        }
        int n = -1;
        Object[] objectArray = vector.toArray();
        Object object = JOptionPane.showInputDialog(this.m_frame, "Choose a palette type to create:", "Choose New Palette Type", 3, null, objectArray, objectArray[0]);
        if (object == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            n = i;
            break;
        }
        if (n < 0 || n >= vector.size()) {
            return false;
        }
        Palette palette = null;
        try {
            palette = vector.elementAt(n).getPaletteInstance(null);
        }
        catch (PaletteInstantiationException paletteInstantiationException) {
            PaletteEditor.console.writeLine("Failed to create instance of \"" + vector.elementAt(n).getName() + "\"!");
            JOptionPane.showMessageDialog(this.m_frame, "Failed to create instance of \"" + vector.elementAt(n).getName() + "\"!", "Instantiation Failed", 0);
            return false;
        }
        Color color = JColorChooser.showDialog(null, "Choose Fill Colour", Color.BLACK);
        if (color == null) {
            return false;
        }
        if (!palette.fillAllWithColour(color)) {
            PaletteEditor.console.writeLine("Failed to fill palette with specified colour!");
            JOptionPane.showMessageDialog(this.m_frame, "Failed to fill palette with specified colour!", "Palette Fill Failed", 0);
            return false;
        }
        PaletteEditor.console.writeLine(vector.elementAt(n).getName() + " palette created successfully!");
        PalettePanel palettePanel = new PalettePanel(palette);
        this.addPalette(palettePanel);
        palettePanel.setChanged(true);
        return true;
    }

    public void promptLoadPalettes() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setDialogTitle("Load Palette Files");
        jFileChooser.setMultiSelectionEnabled(true);
        if (jFileChooser.showOpenDialog(null) != 0) {
            return;
        }
        this.loadPalettes(jFileChooser.getSelectedFiles());
    }

    public int loadPalettes(File[] fileArray) {
        int n;
        if (fileArray == null || fileArray.length == 0) {
            return -1;
        }
        int n2 = 0;
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n] == null || !this.loadPalette(fileArray[n])) continue;
            ++n2;
        }
        if (fileArray.length > 0) {
            n = fileArray.length - n2;
            if (n2 == 0 && n > 0) {
                PaletteEditor.console.writeLine(n + " palette file" + (n == 1 ? "" : "s") + " failed to load, no palette files loaded.");
            } else if (n2 > 1) {
                PaletteEditor.console.writeLine(n2 + " palette files were loaded successfully" + (n == 0 ? "" : ", while " + n + " failed to load") + "!");
            }
        }
        return n2;
    }

    public boolean loadPalette(File file) {
        if (file == null || !file.exists()) {
            PaletteEditor.console.writeLine("File \"" + file.getName() + "\" does not exist.");
            return false;
        }
        for (int i = 0; i < this.m_palettePanels.size(); ++i) {
            if (!this.m_palettePanels.elementAt(i).isSameFile(file)) continue;
            this.selectPalettePanel(this.m_palettePanels.elementAt(i));
            PaletteEditor.console.writeLine("Palette file \"" + (file == null ? "null" : file.getName()) + "\" already loaded!");
            JOptionPane.showMessageDialog(this.m_frame, "Palette file \"" + (file == null ? "null" : file.getName()) + "\" already loaded!", "Already Loaded", 1);
            return true;
        }
        String string = Utilities.getFileExtension(file.getName());
        PalettePlugin palettePlugin = PaletteEditor.pluginManager.getPluginForFileType(string);
        if (palettePlugin == null) {
            PaletteEditor.console.writeLine("No plugin found to load " + string + " file type. Perhaps you forgot to load all plugins?");
            JOptionPane.showMessageDialog(this.m_frame, "No plugin found to load " + string + " file type. Perhaps you forgot to load all plugins?", "No Plugin Found", 0);
            return false;
        }
        Palette palette = null;
        try {
            palette = palettePlugin.getPaletteInstance(file);
        }
        catch (PaletteInstantiationException paletteInstantiationException) {
            PaletteEditor.console.writeLine(paletteInstantiationException.getMessage());
            JOptionPane.showMessageDialog(this.m_frame, paletteInstantiationException.getMessage(), "Plugin Instantiation Failed", 0);
            return false;
        }
        if (palette == null) {
            PaletteEditor.console.writeLine("Failed to instantiate \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + ")\" plugin when attempting to read palette file: \"" + file.getName() + "\".");
            JOptionPane.showMessageDialog(this.m_frame, "Failed to instantiate \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + ")\" plugin when attempting to read palette file: \"" + file.getName() + "\".", "Plugin Instantiation Failed", 0);
            return false;
        }
        try {
            if (!palette.load()) {
                PaletteEditor.console.writeLine("Failed to load palette: \"" + file.getName() + "\" using plugin: \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + ")\".");
                JOptionPane.showMessageDialog(this.m_frame, "Failed to load palette: \"" + file.getName() + "\" using plugin: \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + ")\".", "Palette Loading Failed", 0);
                return false;
            }
        }
        catch (HeadlessException headlessException) {
            PaletteEditor.console.writeLine("Exception thrown while loading palette : \"" + file.getName() + "\" using plugin: \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + "): " + headlessException.getMessage());
            JOptionPane.showMessageDialog(this.m_frame, "Exception thrown while loading palette : \"" + file.getName() + "\" using plugin: \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + "): " + headlessException.getMessage(), "Palette Loading Failed", 0);
            return false;
        }
        catch (PaletteReadException paletteReadException) {
            PaletteEditor.console.writeLine(paletteReadException.getMessage());
            JOptionPane.showMessageDialog(this.m_frame, paletteReadException.getMessage(), "Palette Loading Failed", 0);
            return false;
        }
        PaletteEditor.console.writeLine("Palette file \"" + file.getName() + "\" loaded successfully!");
        this.addPalette(new PalettePanel(palette));
        return true;
    }

    public boolean saveSelectedPalette() {
        return this.savePalette(this.getSelectedPalettePanel());
    }

    public boolean savePalette(PalettePanel palettePanel) {
        int n;
        if (palettePanel == null) {
            return false;
        }
        if (!(palettePanel.isChanged() || (n = JOptionPane.showConfirmDialog(this.m_frame, "No changes detected, save palette anyways?", "No Changes", 1, 3)) != 2 && n != 1)) {
            return false;
        }
        File file = palettePanel.getPalette().getFile();
        if (file == null) {
            return this.savePaletteAsNew(palettePanel);
        }
        try {
            if (palettePanel.save()) {
                PaletteEditor.console.writeLine("Palette successfully updated and saved to file: " + file.getName() + "!");
                this.update();
                return true;
            }
            PaletteEditor.console.writeLine("Failed to update and save palette!");
            JOptionPane.showMessageDialog(this.m_frame, "Failed to update and save palette!", "Save Failed", 0);
            return false;
        }
        catch (PaletteWriteException paletteWriteException) {
            PaletteEditor.console.writeLine(paletteWriteException.getMessage());
            return false;
        }
    }

    public boolean saveSelectedPaletteAsNew() {
        return this.savePaletteAsNew(this.getSelectedPalettePanel());
    }

    public boolean savePaletteAsNew(PalettePanel palettePanel) {
        int n;
        if (palettePanel == null) {
            return false;
        }
        File file = palettePanel.getPalette().getFile();
        JFileChooser jFileChooser = new JFileChooser(file == null ? System.getProperty("user.dir") : Utilities.getFilePath(file));
        jFileChooser.setDialogTitle("Save Palette File As");
        if (file != null) {
            String string = file.getName();
            String string2 = Utilities.getFileExtension(string);
            jFileChooser.setSelectedFile(new File(Utilities.getFileNameNoExtension(string) + (Utilities.compareCasePercentage(string) < 0 ? "_copy" : "_COPY") + (string2 == null ? "" : "." + string2)));
        } else {
            String string = palettePanel.getExtension();
            jFileChooser.setSelectedFile(new File("NEW" + (string == null ? "" : "." + string)));
        }
        do {
            if (jFileChooser.showSaveDialog(null) != 0) {
                return false;
            }
            if (!jFileChooser.getSelectedFile().exists()) break;
            n = JOptionPane.showConfirmDialog(this.m_frame, "The specified file already exists, are you sure you want to overwrite it?", "Overwrite File", 1);
            if (n != 2) continue;
            return false;
        } while (n == 1);
        palettePanel.getPalette().setFile(jFileChooser.getSelectedFile());
        return this.savePalette(palettePanel);
    }

    public void saveAllPalettes() {
        if (this.m_palettePanels.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_palettePanels.size(); ++i) {
            this.savePalette(this.m_palettePanels.elementAt(i));
        }
        this.update();
    }

    public boolean importPalette() {
        int n;
        Object object;
        Object[] objectArray;
        int n2;
        PalettePanel palettePanel = this.getSelectedPalettePanel();
        if (palettePanel == null) {
            return false;
        }
        Palette palette = palettePanel.getPalette();
        JFileChooser jFileChooser = new JFileChooser(palette.getFile() == null ? System.getProperty("user.dir") : Utilities.getFilePath(palette.getFile()));
        jFileChooser.setDialogTitle("Import Palette File");
        if (jFileChooser.showOpenDialog(null) != 0) {
            return false;
        }
        if (!jFileChooser.getSelectedFile().isFile() || !jFileChooser.getSelectedFile().exists()) {
            PaletteEditor.console.writeLine("Selected palette file \"" + jFileChooser.getSelectedFile().getName() + "\" is not a file or does not exist.");
            JOptionPane.showMessageDialog(this.m_frame, "Selected palette file \"" + jFileChooser.getSelectedFile().getName() + "\" is not a file or does not exist.", "Invalid or Missing File", 0);
            return false;
        }
        File file = jFileChooser.getSelectedFile();
        String string = Utilities.getFileExtension(file.getName());
        PalettePlugin palettePlugin = PaletteEditor.pluginManager.getPluginForFileType(string);
        if (palettePlugin == null) {
            PaletteEditor.console.writeLine("No plugin found to import " + string + " file type. Perhaps you forgot to load all plugins?");
            JOptionPane.showMessageDialog(this.m_frame, "No plugin found to import " + string + " file type. Perhaps you forgot to load all plugins?", "No Plugin Found", 0);
            return false;
        }
        Palette palette2 = null;
        try {
            palette2 = palettePlugin.getPaletteInstance(file);
        }
        catch (PaletteInstantiationException paletteInstantiationException) {
            PaletteEditor.console.writeLine(paletteInstantiationException.getMessage());
            JOptionPane.showMessageDialog(this.m_frame, paletteInstantiationException.getMessage(), "Plugin Instantiation Failed", 0);
            return false;
        }
        if (palette2 == null) {
            PaletteEditor.console.writeLine("Failed to instantiate \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + ")\" plugin when attempting to import palette file: \"" + file.getName() + "\".");
            JOptionPane.showMessageDialog(this.m_frame, "Failed to instantiate \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + ")\" plugin when attempting to import palette file: \"" + file.getName() + "\".", "Plugin Instantiation Failed", 0);
            return false;
        }
        try {
            if (!palette2.load()) {
                PaletteEditor.console.writeLine("Failed to import palette: \"" + file.getName() + "\" using plugin: \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + ")\".");
                JOptionPane.showMessageDialog(this.m_frame, "Failed to import palette: \"" + file.getName() + "\" using plugin: \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + ")\".", "Palette Loading Failed", 0);
                return false;
            }
        }
        catch (HeadlessException headlessException) {
            PaletteEditor.console.writeLine("Exception thrown while importing palette : \"" + file.getName() + "\" using plugin: \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + "): " + headlessException.getMessage());
            JOptionPane.showMessageDialog(this.m_frame, "Exception thrown while importing palette : \"" + file.getName() + "\" using plugin: \"" + palettePlugin.getName() + " (" + palettePlugin.getSupportedPaletteFileTypesAsString() + "): " + headlessException.getMessage(), "Palette Loading Failed", 0);
            return false;
        }
        catch (PaletteReadException paletteReadException) {
            PaletteEditor.console.writeLine(paletteReadException.getMessage());
            JOptionPane.showMessageDialog(this.m_frame, paletteReadException.getMessage(), "Palette Importing Failed", 0);
            return false;
        }
        int n3 = 0;
        if (palette2.numberOfPalettes() > 1) {
            if (palette.numberOfPalettes() == palette2.numberOfPalettes()) {
                n2 = JOptionPane.showConfirmDialog(this.m_frame, "The palette you are importing has the same number of sub palettes, would you like to import all sub palettes?", "Import All Sub-Palettes", 1);
                if (n2 == 2) {
                    return false;
                }
                if (n2 == 0) {
                    n3 = -1;
                }
            }
            if (n3 != -1) {
                Vector<String> vector = palette2.getPaletteDescriptions();
                objectArray = new Object[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    objectArray[i] = new String(i + 1 + ": " + vector.elementAt(i));
                }
                object = JOptionPane.showInputDialog(this.m_frame, "Choose a sub palette to import from:", "Choose Sub-Palette Type", 3, null, objectArray, objectArray[0]);
                if (object == null) {
                    return false;
                }
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] != object) continue;
                    n3 = n;
                    break;
                }
                if (n3 < 0 || n3 >= vector.size()) {
                    return false;
                }
            }
        }
        n2 = 0;
        if (n3 == -1) {
            n2 = -1;
        } else if (palette.numberOfPalettes() > 1) {
            objectArray = palette.getPaletteDescriptions();
            object = new Object[objectArray.size()];
            for (n = 0; n < objectArray.size(); ++n) {
                object[n] = new String(n + 1 + ": " + (String)objectArray.elementAt(n));
            }
            Object object2 = JOptionPane.showInputDialog(this.m_frame, "Choose a sub palette to import to:", "Choose Sub-Palette Type", 3, null, object, object[0]);
            if (object2 == null) {
                return false;
            }
            for (int i = 0; i < ((Object[])object).length; ++i) {
                if (object[i] != object2) continue;
                n2 = i;
                break;
            }
            if (n2 < 0 || n2 >= objectArray.size()) {
                return false;
            }
        }
        objectArray = n3 == -1 ? palette2.getAllColourData() : palette2.getColourData(n3);
        boolean bl = false;
        bl = n2 == -1 ? palette.updateAllColourData((Color[])objectArray) : palette.updateColourData(n2, 0, (Color[])objectArray);
        if (bl) {
            palettePanel.setChanged(true);
            PaletteEditor.console.writeLine("Palette file \"" + file.getName() + "\" imported successfully!");
            this.update();
        } else {
            PaletteEditor.console.writeLine("Failed to import palette file \"" + file.getName() + "\" imported successfully!");
        }
        return bl;
    }

    public boolean exportPalette() {
        int n;
        Vector<PalettePlugin> vector;
        int n2;
        PalettePanel palettePanel = this.getSelectedPalettePanel();
        if (palettePanel == null) {
            return false;
        }
        Palette palette = palettePanel.getPalette();
        int n3 = 0;
        if (palette.numberOfPalettes() > 1) {
            if (palette.numberOfPalettes() == palette.numberOfPalettes()) {
                int n4 = JOptionPane.showConfirmDialog(this.m_frame, "The palette you are exporting has multple sub palettes, would you like to export all of them?", "Export All Sub-Palettes", 1);
                if (n4 == 2) {
                    return false;
                }
                if (n4 == 0) {
                    n3 = -1;
                }
            }
            if (n3 != -1) {
                Vector<String> vector2 = palette.getPaletteDescriptions();
                Object[] objectArray = new Object[vector2.size()];
                for (int i = 0; i < vector2.size(); ++i) {
                    objectArray[i] = new String(i + 1 + ": " + vector2.elementAt(i));
                }
                Object object = JOptionPane.showInputDialog(this.m_frame, "Choose a sub palette to export:", "Choose Sub-Palette Type", 3, null, objectArray, objectArray[0]);
                if (object == null) {
                    return false;
                }
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (objectArray[n2] != object) continue;
                    n3 = n2;
                    break;
                }
                if (n3 < 0 || n3 >= vector2.size()) {
                    return false;
                }
            }
        }
        if ((vector = PaletteEditor.pluginManager.getLoadedInstantiablePluginsExcluding(palette.getExtension())).size() == 0) {
            PaletteEditor.console.writeLine("No palette plugins found that support instantiation / exporting. Perhaps you forgot to load all plugins?");
            JOptionPane.showMessageDialog(this.m_frame, "No palette plugins found that support instantiation / exporting. Perhaps you forgot to load all plugins?", "No Plugins", 0);
            return false;
        }
        int n5 = -1;
        int n6 = -1;
        n2 = 0;
        int n7 = 0;
        int n8 = n = n3 < 0 ? 0 : n3;
        while (true) {
            block35: {
                int n9;
                Object object;
                Object object2;
                if (n5 <= 0) {
                    int n10;
                    n6 = -1;
                    object2 = vector.toArray();
                    object = JOptionPane.showInputDialog(this.m_frame, "Choose a palette type to export to:", "Choose Palette Type", 3, null, (Object[])object2, object2[0]);
                    if (object == null) {
                        return false;
                    }
                    for (n10 = 0; n10 < ((Object)object2).length; ++n10) {
                        if (object2[n10] != object) continue;
                        n6 = n10;
                        break;
                    }
                    if (n6 < 0 || n6 >= vector.size()) {
                        return false;
                    }
                    n2 = 0;
                    if (vector.elementAt(n6).numberOfSupportedPaletteFileTypes() > 1) {
                        object2 = vector.elementAt(n6).getSupportedPaletteFileTypes().toArray();
                        object = JOptionPane.showInputDialog(this.m_frame, "Choose a palette file type to export to:", "Choose File Type", 3, null, (Object[])object2, object2[0]);
                        if (object == null) {
                            return false;
                        }
                        for (n10 = 0; n10 < ((Object)object2).length; ++n10) {
                            if (object2[n10] != object) continue;
                            n2 = n10;
                            break;
                        }
                        if (n2 < 0 || n2 >= vector.size()) {
                            return false;
                        }
                    }
                }
                if (palette.numberOfPalettes() > 1 && n5 < 0) {
                    int n11 = JOptionPane.showConfirmDialog(this.m_frame, "Would you like to use the same export settings for all sub-palettes?", "Use Same Export Settings?", 1, 3);
                    if (n11 == 0) {
                        n5 = 1;
                    } else if (n11 == 1) {
                        n5 = 0;
                    }
                }
                object2 = new JFileChooser(palette.getFile() == null ? System.getProperty("user.dir") : Utilities.getFilePath(palette.getFile()));
                ((JFileChooser)object2).setDialogTitle("Export Palette File");
                object = vector.elementAt(n6).getSupportedPaletteFileType(n2);
                if (palette.getFile() != null) {
                    String string = palette.getFile().getName();
                    ((JFileChooser)object2).setSelectedFile(new File(Utilities.getFileNameNoExtension(string) + (palette.numberOfPalettes() > 1 ? "_" + (n + 1) : (Utilities.compareCasePercentage(string) < 0 ? "_copy" : "_COPY")) + "." + (Utilities.compareCasePercentage(string) < 0 ? ((String)object).toLowerCase() : ((String)object).toUpperCase())));
                } else {
                    ((JFileChooser)object2).setSelectedFile(new File("NEW" + (palette.numberOfPalettes() > 1 ? "_" + (n + 1) : "") + "." + (String)object));
                }
                do {
                    if (((JFileChooser)object2).showSaveDialog(null) != 0) {
                        return false;
                    }
                    if (!((JFileChooser)object2).getSelectedFile().exists()) break;
                    n9 = JOptionPane.showConfirmDialog(this.m_frame, "The specified file already exists, are you sure you want to overwrite it?", "Overwrite File", 1);
                    if (n9 != 2) continue;
                    return false;
                } while (n9 == 1);
                Palette palette2 = null;
                try {
                    palette2 = vector.elementAt(n6).getPaletteInstance(((JFileChooser)object2).getSelectedFile());
                }
                catch (PaletteInstantiationException paletteInstantiationException) {
                    PaletteEditor.console.writeLine("Failed to create instance of export file: \"" + vector.elementAt(n6).getName() + " (" + vector.elementAt(n6).getSupportedPaletteFileTypesAsString() + ")!");
                    JOptionPane.showMessageDialog(this.m_frame, "Failed to create instance of export file: \"" + vector.elementAt(n6).getName() + " (" + vector.elementAt(n6).getSupportedPaletteFileTypesAsString() + ")!", "Instantiation Failed", 0);
                    return false;
                }
                if (!palettePanel.updatePaletteData()) {
                    PaletteEditor.console.writeLine("Failed to update palette data for source palette while attempting to export file: \"" + palette.getFile().getName() + "!");
                    JOptionPane.showMessageDialog(this.m_frame, "Failed to update palette data for source palette while attempting to export file: \"" + palette.getFile().getName() + "!", "Update Palette Failed", 0);
                    return false;
                }
                palette2.updateColourData(palette.getColourData(n));
                try {
                    if (palette2.save()) {
                        PaletteEditor.console.writeLine("Palette successfully exported to new file: " + palette2.getFile().getName() + "!");
                        ++n7;
                        break block35;
                    }
                    PaletteEditor.console.writeLine("Failed to export palette!");
                    JOptionPane.showMessageDialog(this.m_frame, "Failed to export palette!", "Export Failed", 0);
                    return false;
                }
                catch (PaletteWriteException paletteWriteException) {
                    PaletteEditor.console.writeLine(paletteWriteException.getMessage());
                    return false;
                }
            }
            if (n3 >= 0 || n >= palette.numberOfPalettes() - 1) break;
            ++n;
        }
        if (n7 > 1) {
            PaletteEditor.console.writeLine("Successfully exported " + n7 + " sub-palettes from palette: \"" + palette.getFile().getName() + "\".");
        }
        return true;
    }

    public boolean closeSelectedPalette() {
        return this.closePalette(this.getSelectedPalettePanel());
    }

    public boolean closePalette(PalettePanel palettePanel) {
        int n;
        if (palettePanel == null) {
            return false;
        }
        Component component = this.getTabComponentWith(palettePanel);
        if (component == null) {
            return false;
        }
        this.m_mainTabbedPane.setSelectedComponent(component);
        if (palettePanel.isChanged()) {
            n = JOptionPane.showConfirmDialog(this.m_frame, "Would you like to save your changes?", "Unsaved Changes", 1);
            if (n == 2) {
                return false;
            }
            if (n == 0 && !this.saveSelectedPalette()) {
                return false;
            }
        }
        this.m_mainTabbedPane.remove(component);
        n = this.m_palettePanels.indexOf(palettePanel);
        this.m_palettePanels.remove(palettePanel);
        if (this.m_palettePanels.size() > 0) {
            this.m_mainTabbedPane.setSelectedComponent(this.getTabComponentWith(this.m_palettePanels.elementAt(n < this.m_palettePanels.size() ? n : n - 1)));
        }
        this.update();
        return true;
    }

    public boolean closeAllPalettes() {
        if (this.m_mainTabbedPane.getComponentCount() > 1) {
            this.m_mainTabbedPane.setSelectedComponent(this.m_mainTabbedPane.getComponent(this.m_mainTabbedPane.getComponentCount() - 2));
        }
        for (int i = this.m_palettePanels.size() - 1; i >= 0; --i) {
            if (this.closePalette(this.m_palettePanels.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    private void updateWindow() {
        this.m_settingsAutoScrollConsoleMenuItem.setSelected(PaletteEditor.settings.autoScrollConsole);
        this.m_settingsLogConsoleMenuItem.setSelected(PaletteEditor.settings.logConsole);
        this.m_settingsSupressUpdatesMenuItem.setSelected(PaletteEditor.settings.supressUpdates);
        this.m_pluginsAutoLoadMenuItem.setSelected(PaletteEditor.settings.autoLoadPlugins);
        this.m_settingsAutoSaveSettingsMenuItem.setSelected(PaletteEditor.settings.autoSaveSettings);
        boolean bl = this.m_mainTabbedPane.getSelectedIndex() != this.m_mainTabbedPane.getTabCount() - 1;
        this.m_fileSaveMenuItem.setEnabled(bl);
        this.m_fileSaveAsMenuItem.setEnabled(bl);
        this.m_fileSaveAllMenuItem.setEnabled(this.m_palettePanels.size() > 0);
        this.m_fileImportMenuItem.setEnabled(bl);
        this.m_fileExportMenuItem.setEnabled(bl);
        this.m_fileCloseMenuItem.setEnabled(bl);
        this.m_fileCloseAllMenuItem.setEnabled(this.m_palettePanels.size() > 0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PalettePanel palettePanel = null;
                for (int i = 0; i < PaletteEditorWindow.this.m_mainTabbedPane.getComponentCount(); ++i) {
                    palettePanel = PaletteEditorWindow.this.getPalettePanelFrom(PaletteEditorWindow.this.m_mainTabbedPane.getComponentAt(i));
                    if (palettePanel == null) continue;
                    PaletteEditorWindow.this.m_mainTabbedPane.setTitleAt(i, palettePanel.getTabName());
                    PaletteEditorWindow.this.m_mainTabbedPane.setToolTipTextAt(i, palettePanel.getTabDescription());
                }
            }
        });
        this.updateLayout();
        this.m_mainTabbedPane.revalidate();
    }

    public void updateLayout() {
        for (int i = 0; i < this.m_palettePanels.size(); ++i) {
            this.m_palettePanels.elementAt(i).updateLayout();
        }
    }

    @Override
    public void update() {
        if (!this.m_initialized) {
            return;
        }
        this.m_consoleText.setText(PaletteEditor.console.toString());
        if (PaletteEditor.settings.autoScrollConsole) {
            JScrollBar jScrollBar = this.m_consoleScrollPane.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.m_consoleScrollPane.getVerticalScrollBar();
            if (!jScrollBar.getValueIsAdjusting() && !jScrollBar2.getValueIsAdjusting()) {
                jScrollBar.setValue(jScrollBar.getMinimum());
                jScrollBar2.setValue(jScrollBar2.getMaximum());
            }
        }
        this.m_updating = true;
        this.updateWindow();
        this.m_updating = false;
    }

    public void changeBackgroundColourPrompt() {
        Color color = JColorChooser.showDialog(null, "Choose background colour", PaletteEditor.settings.backgroundColour);
        if (color == null) {
            return;
        }
        PaletteEditor.settings.backgroundColour = color;
        this.update();
    }

    public void resetWindowPosition() {
        PaletteEditor.settings.windowPositionX = 0;
        PaletteEditor.settings.windowPositionY = 0;
        this.m_frame.setLocation(PaletteEditor.settings.windowPositionX, PaletteEditor.settings.windowPositionY);
    }

    public void resetWindowSize() {
        PaletteEditor.settings.windowWidth = 800;
        PaletteEditor.settings.windowHeight = 600;
        this.m_frame.setSize(PaletteEditor.settings.windowWidth, PaletteEditor.settings.windowHeight);
    }

    public void changePixelButtonSizePrompt() {
        String string = JOptionPane.showInputDialog(this.m_frame, "Please enter the desired pixel button size:", PaletteEditor.settings.pixelButtonSize);
        if (string == null) {
            return;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.m_frame, "Invalid pixel button size entered.", "Invalid Number", 0);
            return;
        }
        if (n >= 1 && n <= 64) {
            PaletteEditor.console.writeLine("Pixel button size changed from " + PaletteEditor.settings.pixelButtonSize + " to " + n + ".");
            PaletteEditor.settings.pixelButtonSize = n;
            this.update();
        } else {
            PaletteEditor.console.writeLine("Pixel button size must be between 1 and 64.");
        }
    }

    public void changePaletteSpacingPrompt() {
        String string = JOptionPane.showInputDialog(this.m_frame, "Please enter the distance for palette spacing:", PaletteEditor.settings.paletteSpacing);
        if (string == null) {
            return;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.m_frame, "Invalid palette spacing distance entered.", "Invalid Number", 0);
            return;
        }
        if (n >= 0 && n <= 128) {
            PaletteEditor.console.writeLine("Palette spacing changed from " + PaletteEditor.settings.paletteSpacing + " to " + n + ".");
            PaletteEditor.settings.paletteSpacing = n;
            this.update();
        } else {
            PaletteEditor.console.writeLine("Palette spacing must be between 0 and 128.");
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.m_frame) {
            this.close();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_updating) {
            return;
        }
        if (actionEvent.getSource() == this.m_fileNewMenuItem) {
            this.promptNewPalette();
        } else if (actionEvent.getSource() == this.m_fileOpenMenuItem) {
            this.promptLoadPalettes();
        } else if (actionEvent.getSource() == this.m_fileSaveMenuItem) {
            this.saveSelectedPalette();
        } else if (actionEvent.getSource() == this.m_fileSaveAsMenuItem) {
            this.saveSelectedPaletteAsNew();
        } else if (actionEvent.getSource() == this.m_fileSaveAllMenuItem) {
            this.saveAllPalettes();
        } else if (actionEvent.getSource() == this.m_fileImportMenuItem) {
            this.importPalette();
        } else if (actionEvent.getSource() == this.m_fileExportMenuItem) {
            this.exportPalette();
        } else if (actionEvent.getSource() == this.m_fileCloseMenuItem) {
            this.closeSelectedPalette();
        } else if (actionEvent.getSource() == this.m_fileCloseAllMenuItem) {
            this.closeAllPalettes();
        } else if (actionEvent.getSource() == this.m_fileExitMenuItem) {
            this.close();
        } else if (actionEvent.getSource() == this.m_settingsPluginDirectoryNameMenuItem) {
            String string = JOptionPane.showInputDialog(this.m_frame, "Please enter the plugin directory name:", PaletteEditor.settings.pluginDirectoryName);
            if (string == null) {
                return;
            }
            String string2 = string.trim();
            if (string2.length() == 0) {
                return;
            }
            if (!string2.equalsIgnoreCase(PaletteEditor.settings.pluginDirectoryName)) {
                PaletteEditor.settings.pluginDirectoryName = string2;
            }
        } else if (actionEvent.getSource() == this.m_settingsConsoleLogFileNameMenuItem) {
            String string = JOptionPane.showInputDialog(this.m_frame, "Please enter the console log file name:", PaletteEditor.settings.consoleLogFileName);
            if (string == null) {
                return;
            }
            String string3 = string.trim();
            if (string3.length() == 0) {
                return;
            }
            if (!string3.equalsIgnoreCase(PaletteEditor.settings.consoleLogFileName)) {
                PaletteEditor.console.resetConsoleLogFileHeader();
                PaletteEditor.settings.consoleLogFileName = string3;
            }
        } else if (actionEvent.getSource() == this.m_settingsLogDirectoryNameMenuItem) {
            String string = JOptionPane.showInputDialog(this.m_frame, "Please enter the log directory name:", PaletteEditor.settings.logDirectoryName);
            if (string == null) {
                return;
            }
            String string4 = string.trim();
            if (string4.length() == 0) {
                return;
            }
            if (!string4.equalsIgnoreCase(PaletteEditor.settings.logDirectoryName)) {
                PaletteEditor.settings.logDirectoryName = string4;
            }
        } else if (actionEvent.getSource() == this.m_settingsVersionFileURLMenuItem) {
            String string = JOptionPane.showInputDialog(this.m_frame, "Please enter the version file URL:", PaletteEditor.settings.versionFileURL);
            if (string == null) {
                return;
            }
            String string5 = string.trim();
            if (string5.length() == 0) {
                return;
            }
            if (!string5.equalsIgnoreCase(PaletteEditor.settings.versionFileURL)) {
                PaletteEditor.settings.versionFileURL = string5;
            }
        } else if (actionEvent.getSource() == this.m_settingsBackgroundColourMenuItem) {
            this.changeBackgroundColourPrompt();
        } else if (actionEvent.getSource() == this.m_settingsAutoScrollConsoleMenuItem) {
            PaletteEditor.settings.autoScrollConsole = this.m_settingsAutoScrollConsoleMenuItem.isSelected();
        } else if (actionEvent.getSource() == this.m_settingsMaxConsoleHistoryMenuItem) {
            String string = JOptionPane.showInputDialog(this.m_frame, "Please enter the maximum console history size:", PaletteEditor.settings.maxConsoleHistory);
            if (string == null) {
                return;
            }
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.m_frame, "Invalid number entered for maximum console history.", "Invalid Number", 0);
                return;
            }
            if (n > 1) {
                PaletteEditor.settings.maxConsoleHistory = n;
            }
        } else if (actionEvent.getSource() == this.m_settingsLogConsoleMenuItem) {
            PaletteEditor.settings.logConsole = this.m_settingsLogConsoleMenuItem.isSelected();
        } else if (actionEvent.getSource() == this.m_settingsSupressUpdatesMenuItem) {
            PaletteEditor.settings.supressUpdates = this.m_settingsSupressUpdatesMenuItem.isSelected();
        } else if (actionEvent.getSource() == this.m_settingsAutoSaveSettingsMenuItem) {
            PaletteEditor.settings.autoSaveSettings = this.m_settingsAutoSaveSettingsMenuItem.isSelected();
        } else if (actionEvent.getSource() == this.m_settingsSaveSettingsMenuItem) {
            if (PaletteEditor.settings.save()) {
                PaletteEditor.console.writeLine("Successfully saved settings to file: " + PaletteEditor.settings.settingsFileName);
                JOptionPane.showMessageDialog(this.m_frame, "Successfully saved settings to file: " + PaletteEditor.settings.settingsFileName, "Settings Saved", 1);
            } else {
                PaletteEditor.console.writeLine("Failed to save settings to file: " + PaletteEditor.settings.settingsFileName);
                JOptionPane.showMessageDialog(this.m_frame, "Failed to save settings to file: " + PaletteEditor.settings.settingsFileName, "Settings Not Saved", 0);
            }
        } else if (actionEvent.getSource() == this.m_settingsReloadSettingsMenuItem) {
            if (PaletteEditor.settings.load()) {
                this.update();
                PaletteEditor.console.writeLine("Settings successfully loaded from file: " + PaletteEditor.settings.settingsFileName);
                JOptionPane.showMessageDialog(this.m_frame, "Settings successfully loaded from file: " + PaletteEditor.settings.settingsFileName, "Settings Loaded", 1);
            } else {
                PaletteEditor.console.writeLine("Failed to load settings from file: " + PaletteEditor.settings.settingsFileName);
                JOptionPane.showMessageDialog(this.m_frame, "Failed to load settings from file: " + PaletteEditor.settings.settingsFileName, "Settings Not Loaded", 0);
            }
        } else if (actionEvent.getSource() == this.m_settingsResetSettingsMenuItem) {
            int n = JOptionPane.showConfirmDialog(this.m_frame, "Are you sure you wish to reset all settings?", "Reset All Settings", 1, 3);
            if (n == 0) {
                PaletteEditor.settings.reset();
                this.update();
                PaletteEditor.console.writeLine("All settings reset to default values");
            }
        } else if (actionEvent.getSource() == this.m_pluginsListLoadedMenuItem) {
            PaletteEditor.instance.displayLoadedPlugins();
        } else if (actionEvent.getSource() == this.m_pluginsLoadMenuItem) {
            PaletteEditor.instance.loadPluginPrompt();
        } else if (actionEvent.getSource() == this.m_pluginsLoadAllMenuItem) {
            PaletteEditor.instance.loadPlugins();
        } else if (actionEvent.getSource() == this.m_pluginsAutoLoadMenuItem) {
            PaletteEditor.settings.autoLoadPlugins = this.m_pluginsAutoLoadMenuItem.isSelected();
            this.update();
        } else if (actionEvent.getSource() == this.m_buttonSizeMenuItem) {
            this.changePixelButtonSizePrompt();
        } else if (actionEvent.getSource() == this.m_paletteSpacingMenuItem) {
            this.changePaletteSpacingPrompt();
        } else if (actionEvent.getSource() == this.m_windowResetPositionMenuItem) {
            this.resetWindowPosition();
        } else if (actionEvent.getSource() == this.m_windowResetSizeMenuItem) {
            this.resetWindowSize();
        } else if (actionEvent.getSource() == this.m_helpCheckVersionMenuItem) {
            VersionChecker.checkVersion();
        } else if (actionEvent.getSource() == this.m_helpAboutMenuItem) {
            JOptionPane.showMessageDialog(this.m_frame, "Palette Editor Version 1.0.1\nCreated by Kevin Scroggins (a.k.a. nitro_glycerine)\nE-Mail: nitro404@gmail.com\nWebsite: http://www.nitro404.com", "About Palette Editor", 1);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.m_updating) {
            return;
        }
        if (changeEvent.getSource() == this.m_mainTabbedPane && this.m_mainTabbedPane.getSelectedIndex() >= 0 && this.m_mainTabbedPane.getSelectedIndex() < this.m_mainTabbedPane.getTabCount()) {
            this.update();
        }
        for (int i = 0; i < this.m_palettePanels.size(); ++i) {
            this.m_palettePanels.elementAt(i).updateLayout();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.updateLayout();
    }

    public void close() {
        if (!this.closeAllPalettes()) {
            return;
        }
        this.m_initialized = false;
        PaletteEditor.settings.windowPositionX = this.m_frame.getX();
        PaletteEditor.settings.windowPositionY = this.m_frame.getY();
        PaletteEditor.settings.windowWidth = this.m_frame.getWidth();
        PaletteEditor.settings.windowHeight = this.m_frame.getHeight();
        PaletteEditor.instance.close();
        this.m_frame.dispose();
        System.exit(0);
    }
}

