/*
 * Decompiled with CFR 0.152.
 */
package gui;

import exception.PaletteWriteException;
import gui.PixelButton;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import palette.Palette;
import palette.PaletteChangeListener;
import palette.PaletteEditor;
import settings.SettingsManager;
import utilities.Updatable;

public class PalettePanel
extends JPanel
implements Scrollable,
ActionListener,
MouseListener,
Updatable {
    private int m_paletteNumber;
    private Palette m_palette;
    private PixelButton[] m_buttons;
    private Dimension m_dimensions;
    private Vector<PaletteChangeListener> m_paletteChangeListeners;
    private boolean m_changed;
    private boolean m_initialized;
    public static final int PALETTE_SPACING = 32;
    private JPopupMenu m_palettePanelPopupMenu;
    private JMenuItem m_savePopupMenuItem;
    private JMenuItem m_saveAsPopupMenuItem;
    private JMenuItem m_importPopupMenuItem;
    private JMenuItem m_exportPopupMenuItem;
    private JMenuItem m_closePopupMenuItem;
    private JMenuItem m_canelPopupMenuItem;
    private static final long serialVersionUID = -7026896833349413736L;

    public PalettePanel() {
        this((Palette)null);
    }

    public PalettePanel(Palette palette) {
        this.setLayout(null);
        this.setBackground(SettingsManager.defaultBackgroundColour);
        this.m_paletteNumber = PaletteEditor.getPaletteNumber();
        this.m_dimensions = new Dimension(256, 256);
        this.m_paletteChangeListeners = new Vector();
        this.m_changed = false;
        this.m_initialized = false;
        this.setPalette(palette);
        this.initPopupMenu();
        this.addMouseListener(this);
    }

    public void initPopupMenu() {
        this.m_palettePanelPopupMenu = new JPopupMenu();
        this.m_savePopupMenuItem = new JMenuItem("Save");
        this.m_saveAsPopupMenuItem = new JMenuItem("Save As");
        this.m_importPopupMenuItem = new JMenuItem("Import");
        this.m_exportPopupMenuItem = new JMenuItem("Export");
        this.m_closePopupMenuItem = new JMenuItem("Close");
        this.m_canelPopupMenuItem = new JMenuItem("Cancel");
        this.m_savePopupMenuItem.addActionListener(this);
        this.m_saveAsPopupMenuItem.addActionListener(this);
        this.m_importPopupMenuItem.addActionListener(this);
        this.m_exportPopupMenuItem.addActionListener(this);
        this.m_closePopupMenuItem.addActionListener(this);
        this.m_canelPopupMenuItem.addActionListener(this);
        this.m_palettePanelPopupMenu.add(this.m_savePopupMenuItem);
        this.m_palettePanelPopupMenu.add(this.m_saveAsPopupMenuItem);
        this.m_palettePanelPopupMenu.add(this.m_importPopupMenuItem);
        this.m_palettePanelPopupMenu.add(this.m_exportPopupMenuItem);
        this.m_palettePanelPopupMenu.add(this.m_closePopupMenuItem);
        this.m_palettePanelPopupMenu.addSeparator();
        this.m_palettePanelPopupMenu.add(this.m_canelPopupMenuItem);
    }

    public int getPaletteNumber() {
        return this.m_paletteNumber;
    }

    public String getTabName() {
        String string;
        String string2 = string = this.m_palette.getFile() == null ? null : this.m_palette.getFile().getName();
        return string == null ? "NEW " + this.m_palette.getType() + " *" : string + (this.m_changed ? " *" : "");
    }

    public String getTabDescription() {
        String string = this.m_palette.getFile() == null ? null : this.m_palette.getFile().getName();
        return "Palette " + this.m_paletteNumber + (string == null ? "" : " (" + string + ")");
    }

    public Palette getPalette() {
        return this.m_palette;
    }

    public String getExtension() {
        return this.m_palette.getExtension();
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public void setChanged(boolean bl) {
        this.m_changed = bl;
        if (this.m_changed) {
            this.handlePaletteChange();
        }
    }

    public boolean isSameFile(File file) {
        if (file == null || this.m_palette.getFile() == null) {
            return false;
        }
        File file2 = null;
        File file3 = null;
        try {
            file2 = this.m_palette.getFile().getCanonicalFile();
            file3 = file.getCanonicalFile();
            return file2.equals(file3);
        }
        catch (IOException iOException) {
            return this.m_palette.getFile().equals(file);
        }
    }

    public int numberOfPaletteChangeListeners() {
        return this.m_paletteChangeListeners.size();
    }

    public PaletteChangeListener getPaletteChangeListener(int n) {
        if (n < 0 || n >= this.m_paletteChangeListeners.size()) {
            return null;
        }
        return this.m_paletteChangeListeners.elementAt(n);
    }

    public boolean hasPaletteChangeListener(PaletteChangeListener paletteChangeListener) {
        return this.m_paletteChangeListeners.contains(paletteChangeListener);
    }

    public int indexOfPaletteChangeListener(PaletteChangeListener paletteChangeListener) {
        return this.m_paletteChangeListeners.indexOf(paletteChangeListener);
    }

    public boolean addPaletteChangeListener(PaletteChangeListener paletteChangeListener) {
        if (paletteChangeListener == null || this.m_paletteChangeListeners.contains(paletteChangeListener)) {
            return false;
        }
        this.m_paletteChangeListeners.add(paletteChangeListener);
        return true;
    }

    public boolean removePaletteChangeListener(int n) {
        if (n < 0 || n >= this.m_paletteChangeListeners.size()) {
            return false;
        }
        this.m_paletteChangeListeners.remove(n);
        return true;
    }

    public boolean removePaletteChangeListener(PaletteChangeListener paletteChangeListener) {
        if (paletteChangeListener == null) {
            return false;
        }
        return this.m_paletteChangeListeners.remove(paletteChangeListener);
    }

    public void clearPaletteChangeListeners() {
        this.m_paletteChangeListeners.clear();
    }

    public void handlePaletteChange() {
        for (int i = 0; i < this.m_paletteChangeListeners.size(); ++i) {
            this.m_paletteChangeListeners.elementAt(i).notifyPaletteChanged(this);
        }
    }

    private void setPalette(Palette palette) {
        int n;
        this.m_palette = palette;
        if (this.m_buttons != null) {
            for (n = 0; n < this.m_buttons.length; ++n) {
                this.remove(this.m_buttons[n]);
            }
            this.m_buttons = null;
        }
        if (this.m_palette == null) {
            this.m_initialized = false;
        } else {
            n = 256 * this.m_palette.numberOfPalettes();
            int n2 = 0;
            this.m_buttons = new PixelButton[n];
            for (int i = 0; i < this.m_palette.numberOfPalettes(); ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int k = 0; k < 16; ++k) {
                        n2 = i * 256 + j * 16 + k;
                        this.m_buttons[n2] = new PixelButton(this.m_palette.getPixel(i, k, j), k, j, i);
                        this.m_buttons[n2].addActionListener(this);
                        this.add(this.m_buttons[n2]);
                    }
                }
            }
            this.m_initialized = true;
        }
        this.updateLayout();
    }

    public boolean updatePaletteData() {
        if (!this.m_initialized) {
            return false;
        }
        int n = this.m_palette.numberOfPalettes();
        Color[] colorArray = new Color[256 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    n2 = i * 256 + j * 16 + k;
                    colorArray[n2] = this.m_buttons[n2].getBackground();
                }
            }
        }
        return this.m_palette.updateAllColourData(colorArray);
    }

    public boolean updatePixelButtons() {
        if (!this.m_initialized) {
            return false;
        }
        for (int i = 0; i < this.m_palette.numberOfPalettes(); ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    this.m_buttons[i * 256 + j * 16 + k].setBackground(this.m_palette.getPixel(i, k, j));
                }
            }
        }
        return true;
    }

    public boolean save() throws PaletteWriteException {
        return this.save(true);
    }

    public boolean save(boolean bl) throws PaletteWriteException {
        if (!this.m_initialized) {
            return false;
        }
        if (bl && !this.updatePaletteData()) {
            return false;
        }
        boolean bl2 = this.m_palette.save();
        if (bl2) {
            this.setChanged(false);
        }
        return bl2;
    }

    @Override
    public void update() {
        if (!this.m_initialized) {
            return;
        }
        this.setBackground(PaletteEditor.settings.backgroundColour);
        this.repaint();
        this.revalidate();
    }

    public void updateLayout() {
        if (!this.m_initialized) {
            return;
        }
        this.setBackground(PaletteEditor.settings.backgroundColour);
        Container container = this.getParent();
        int n = container == null ? 0 : container.getWidth();
        int n2 = container == null ? 0 : container.getHeight();
        int n3 = PaletteEditor.settings.pixelButtonSize;
        int n4 = PaletteEditor.settings.paletteSpacing;
        int n5 = 16 * n3;
        int n6 = 16 * n3;
        int n7 = 1 + (container == null ? 1 : (int)Math.floor((float)(n - n5) / (float)(n5 + n4)));
        int n8 = (int)Math.ceil((float)this.m_palette.numberOfPalettes() / (float)n7);
        int n9 = n5 + (this.m_palette.numberOfPalettes() > 1 ? n5 + n4 : 0);
        int n10 = n8 * n6 + (n8 - 1) * n4;
        this.m_dimensions = new Dimension(n > n9 ? n : n9, n2 > n10 ? n2 : n10);
        int n11 = this.m_palette.numberOfPalettes();
        int n12 = 256;
        int n13 = 16 * n3 + n4;
        int n14 = 16 * n3 + n4;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        for (int i = 0; i < n11; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    n17 = i * n12 + j * 16 + k;
                    this.m_buttons[n17].setLocation(k * n3 + n15 * n13, j * n3 + n16 * n14);
                    this.m_buttons[n17].setPreferredSize(new Dimension(n3, n3));
                    this.m_buttons[n17].setSize(n3, n3);
                    this.m_buttons[n17].setBackground(this.m_palette.getPixel(i, k, j));
                }
            }
            if (n15 >= n7 - 1) {
                ++n16;
                n15 = 0;
                continue;
            }
            ++n15;
        }
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.m_initialized || actionEvent == null || actionEvent.getSource() == null) {
            return;
        }
        if (actionEvent.getSource() instanceof PixelButton) {
            PixelButton pixelButton = (PixelButton)actionEvent.getSource();
            if (pixelButton.chooseColour()) {
                this.m_palette.updatePixel(pixelButton.getPixelX(), pixelButton.getPixelY(), pixelButton.getBackground(), pixelButton.getPaletteIndex());
                this.setChanged(true);
            }
        } else if (actionEvent.getSource() == this.m_savePopupMenuItem) {
            PaletteEditor.paletteEditorWindow.saveSelectedPalette();
        } else if (actionEvent.getSource() == this.m_saveAsPopupMenuItem) {
            PaletteEditor.paletteEditorWindow.saveSelectedPaletteAsNew();
        } else if (actionEvent.getSource() == this.m_importPopupMenuItem) {
            PaletteEditor.paletteEditorWindow.importPalette();
        } else if (actionEvent.getSource() == this.m_exportPopupMenuItem) {
            PaletteEditor.paletteEditorWindow.exportPalette();
        } else if (actionEvent.getSource() == this.m_closePopupMenuItem) {
            PaletteEditor.paletteEditorWindow.closeSelectedPalette();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.m_initialized) {
            return;
        }
        if (mouseEvent.getButton() == 3) {
            this.m_palettePanelPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_dimensions;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        n3 = n == 0 ? rectangle.x : rectangle.y;
        int n4 = 40;
        if (n2 < 0) {
            int n5 = n3 - n3 / n4 * n4;
            return n5 == 0 ? n4 : n5;
        }
        return (n3 / n4 + 1) * n4 - n3;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width - 5;
        }
        return rectangle.height - 5;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

