/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import utilities.Task;
import utilities.TaskListener;

public class ProgressDialog
extends JDialog
implements TaskListener,
ActionListener,
KeyListener {
    private boolean m_cancelled;
    private JPanel m_mainPanel;
    private JLabel m_messageLabel;
    private JProgressBar m_progressBar;
    private JButton m_cancelButton;
    private static final long serialVersionUID = -6769263380656386615L;

    public ProgressDialog(Frame frame) {
        super(frame, true);
        this.setTitle("Progress");
        this.setSize(260, 130);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProgressDialog.this.cancel();
            }
        });
        this.m_cancelled = false;
        this.initComponents();
    }

    private void initComponents() {
        this.m_mainPanel = new JPanel();
        this.m_messageLabel = new JLabel(" ");
        this.m_progressBar = new JProgressBar(0, 1);
        this.m_progressBar.setStringPainted(true);
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.addKeyListener(this);
        this.m_cancelButton.addActionListener(this);
        this.m_mainPanel.add(this.m_messageLabel);
        this.m_mainPanel.add(this.m_progressBar);
        this.m_mainPanel.add(this.m_cancelButton);
        this.setContentPane(this.m_mainPanel);
        this.initLayout();
    }

    private void initLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_mainPanel.setLayout(gridBagLayout);
        Insets insets = new Insets(6, 6, 6, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.m_messageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.m_progressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.m_cancelButton, gridBagConstraints);
    }

    public boolean userCancelled() {
        return this.m_cancelled;
    }

    public void close() {
        this.clear();
        this.m_cancelled = false;
        this.setVisible(false);
    }

    private void cancel() {
        this.clear();
        this.m_cancelled = true;
        this.setVisible(false);
    }

    public void clear() {
        this.setTitle("Progress");
        this.m_messageLabel.setText("");
        this.m_progressBar.setMinimum(0);
        this.m_progressBar.setMaximum(1);
        this.m_progressBar.setValue(0);
    }

    public void display(String string, String string2, int n, int n2) {
        if (string == null || string.trim().length() == 0 || n < 0 || n2 <= n) {
            return;
        }
        this.setTitle(string.trim());
        this.m_messageLabel.setText(string2 == null ? " " : string2.trim());
        this.m_progressBar.setMinimum(n);
        this.m_progressBar.setMaximum(n2);
        this.m_progressBar.setValue(n);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.m_cancelButton && (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == ' ')) {
            this.cancel();
        }
        if (keyEvent.getKeyChar() == '\u001b') {
            this.cancel();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_cancelButton) {
            this.cancel();
        }
    }

    @Override
    public void taskProgressChanged(Task task) {
        this.m_progressBar.setValue(task.getProgress());
        if (task.isCompleted()) {
            this.close();
        }
    }

    @Override
    public void taskCancelled(Task task) {
        this.cancel();
    }
}

