/*
 * Decompiled with CFR 0.152.
 */
package palette;

import exception.PaletteReadException;
import exception.PaletteWriteException;
import java.awt.Color;
import java.io.File;
import java.util.Vector;
import utilities.Utilities;

public abstract class Palette {
    protected File m_file;
    protected boolean m_loaded;
    public static final int PALETTE_WIDTH = 16;
    public static final int PALETTE_HEIGHT = 16;
    public static final int NUMBER_OF_COLOURS = 256;

    public Palette() {
        this(null);
    }

    public Palette(File file) {
        this.m_file = file;
        this.m_loaded = false;
    }

    public File getFile() {
        return this.m_file;
    }

    public void setFile(File file) {
        this.m_file = file;
    }

    public String getExtension() {
        return this.m_file == null ? this.getDefaultFileType() : Utilities.getFileExtension(this.m_file.getName());
    }

    public String getType() {
        return this.getDefaultFileType();
    }

    public abstract int numberOfFileTypes();

    public abstract String getFileType(int var1);

    public boolean hasFileType(String string) {
        return this.indexOfFileType(string) >= 0;
    }

    public abstract int indexOfFileType(String var1);

    public String getDefaultFileType() {
        return this.getFileType(0);
    }

    public boolean isLoaded() {
        return this.m_loaded;
    }

    public int numberOfPalettes() {
        return 1;
    }

    public abstract String getPaletteDescription(int var1);

    public String getPaletteDescriptionsAsString() {
        String string = new String();
        for (int i = 0; i < this.numberOfPalettes(); ++i) {
            if (string.length() < 0) {
                string = string + ", ";
            }
            string = string + this.getPaletteDescription(i);
        }
        return string;
    }

    public Vector<String> getPaletteDescriptions() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.numberOfPalettes(); ++i) {
            vector.add(this.getPaletteDescription(i));
        }
        return vector;
    }

    public boolean isInstantiable() {
        return true;
    }

    public Color getPixel(int n, int n2) {
        return this.getPixel(0, n, n2);
    }

    public abstract Color getPixel(int var1, int var2, int var3);

    public boolean updatePixel(int n, int n2, Color color) {
        return this.updatePixel(n, n2, color, 0);
    }

    public abstract boolean updatePixel(int var1, int var2, Color var3, int var4);

    public Color[] getColourData() {
        return this.getColourData(0);
    }

    public abstract Color[] getColourData(int var1);

    public Color[] getAllColourData() {
        return this.getColourData(0);
    }

    public boolean updateColourData(Color[] colorArray) {
        return this.updateColourData(0, 0, colorArray);
    }

    public boolean updateColourData(int n, Color[] colorArray) {
        return this.updateColourData(n, 0, colorArray);
    }

    public abstract boolean updateColourData(int var1, int var2, Color[] var3);

    public boolean updateAllColourData(Color[] colorArray) {
        return this.updateColourData(0, 0, colorArray);
    }

    public boolean fillWithColour(Color color) {
        return this.fillWithColour(color, 0);
    }

    public abstract boolean fillWithColour(Color var1, int var2);

    public boolean fillAllWithColour(Color color) {
        return this.fillWithColour(color, -1);
    }

    public abstract boolean load() throws PaletteReadException;

    public boolean save() throws PaletteWriteException {
        return this.save(this.getExtension());
    }

    public abstract boolean save(String var1) throws PaletteWriteException;
}

