/*
 * Decompiled with CFR 0.152.
 */
package palette;

import console.SystemConsole;
import gui.PaletteEditorWindow;
import gui.PalettePanel;
import gui.ProgressDialog;
import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;
import palette.PaletteChangeListener;
import palette.PalettePlugin;
import palette.PluginManager;
import settings.SettingsManager;
import utilities.ExtendedClassLoader;
import utilities.Task;
import variable.Variable;
import variable.VariableSystem;
import version.VersionChecker;

public class PaletteEditor
implements PaletteChangeListener {
    public static PaletteEditor instance;
    public static PaletteEditorWindow paletteEditorWindow;
    public static SettingsManager settings;
    public static SystemConsole console;
    public static ExtendedClassLoader classLoader;
    public static PluginManager pluginManager;
    private ProgressDialog m_progressDialog;
    private boolean m_initialized;
    private static int currentPaletteNumber;
    public static final String VERSION = "1.0.1";

    public PaletteEditor() {
        paletteEditorWindow = new PaletteEditorWindow();
        instance = this;
        settings = new SettingsManager();
        classLoader = new ExtendedClassLoader();
        console = new SystemConsole();
        pluginManager = new PluginManager();
        this.m_progressDialog = new ProgressDialog(paletteEditorWindow.getFrame());
        this.m_initialized = false;
    }

    public boolean initialize(String[] stringArray) {
        String string;
        if (this.m_initialized) {
            return false;
        }
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null && (string = stringArray[0].trim()).length() > 0) {
            PaletteEditor.settings.settingsFileName = string;
        }
        if (settings.load()) {
            console.writeLine("Settings successfully loaded from file: " + PaletteEditor.settings.settingsFileName);
        } else {
            console.writeLine("Failed to load settings from file: " + PaletteEditor.settings.settingsFileName);
            if (PaletteEditor.settings.settingsFileName != null && !"Palette Editor.ini".equalsIgnoreCase(PaletteEditor.settings.settingsFileName)) {
                String string2;
                int n;
                boolean bl = false;
                while (!bl && (n = JOptionPane.showConfirmDialog(null, "Unable to load settings from custom settings file. Use alternate settings file?\nNote that when the program is closed, this settings file will be generated if it does not exist.", "Settings Loading Failed", 1)) == 0 && (string2 = JOptionPane.showInputDialog(null, "Enter a settings file name:", "Palette Editor.ini")) != null) {
                    PaletteEditor.settings.settingsFileName = string2;
                    bl = settings.load();
                    if (!bl) continue;
                    console.writeLine("Settings successfully loaded from file: " + PaletteEditor.settings.settingsFileName);
                }
            }
        }
        if (PaletteEditor.settings.autoLoadPlugins) {
            this.loadPlugins();
        }
        this.m_initialized = true;
        boolean bl = false;
        console.addTarget(paletteEditorWindow);
        if (!paletteEditorWindow.initialize()) {
            JOptionPane.showMessageDialog(null, "Failed to initialize palette editor window!", "Palette Editor Init Failed", 0);
            return false;
        }
        if (!bl) {
            console.writeLine("Palette Editor initialized successfully!");
        }
        VersionChecker.checkVersion(false);
        return true;
    }

    public static int getPaletteNumber() {
        return currentPaletteNumber++;
    }

    public static int currentPaletteNumber() {
        return currentPaletteNumber;
    }

    public void displayLoadedPlugins() {
        Vector<PalettePlugin> vector = pluginManager.getLoadedPlugins();
        if (vector.size() > 0) {
            String string = new String();
            for (int i = 0; i < vector.size(); ++i) {
                string = string + (i + 1) + ": " + vector.elementAt(i).getName() + (i < vector.size() - 1 ? "\n" : "");
            }
            JOptionPane.showMessageDialog(paletteEditorWindow.getFrame(), "Detected " + vector.size() + " loaded plugin" + (vector.size() == 1 ? "" : "s") + ":\n" + string, vector.size() + " Plugin" + (vector.size() == 1 ? "" : "s") + " Loaded", 1);
        } else {
            JOptionPane.showMessageDialog(paletteEditorWindow.getFrame(), "No plugins currently loaded.", "No Plugins Loaded", 1);
        }
    }

    public boolean loadPluginPrompt() {
        VariableSystem variableSystem = pluginManager.getUnloadedPlugins(new File(PaletteEditor.settings.pluginDirectoryName));
        if (variableSystem.size() == 0) {
            JOptionPane.showMessageDialog(paletteEditorWindow.getFrame(), "No unloaded plugins found.", "No Unloaded Plugins", 1);
            return false;
        }
        Object[] objectArray = new String[variableSystem.size()];
        for (int i = 0; i < variableSystem.size(); ++i) {
            objectArray[i] = variableSystem.variableAt(i).getID();
        }
        String string = (String)JOptionPane.showInputDialog(paletteEditorWindow.getFrame(), "Choose a plugin to load:", "Load Plugin", 3, null, objectArray, objectArray[0]);
        if (string == null) {
            return false;
        }
        Variable variable = variableSystem.getVariable(string);
        if (variable == null) {
            return false;
        }
        return this.loadPlugin(variable.getID(), variable.getValue());
    }

    public boolean loadPlugin(String string, final String string2) {
        if (string2 == null) {
            return false;
        }
        int n = pluginManager.numberOfPlugins();
        final Task task = new Task(1, this.m_progressDialog);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                pluginManager.loadPlugin(new File(string2), task);
            }
        });
        thread.start();
        this.m_progressDialog.display("Loading", "Loading plugin...", 0, 1);
        if (this.m_progressDialog.userCancelled() || !task.isCompleted()) {
            task.cancel();
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_progressDialog.clear();
        }
        paletteEditorWindow.update();
        if (n == pluginManager.numberOfPlugins()) {
            if (!this.m_progressDialog.userCancelled()) {
                console.writeLine("Failed to load plugin" + (string == null ? "" : ": " + string));
                JOptionPane.showMessageDialog(paletteEditorWindow.getFrame(), "Failed to load plugin " + (string == null ? "" : ": " + string), "Loading Failed", 0);
            }
            return false;
        }
        console.writeLine("Successfully loaded plugin" + (string == null ? "" : ": " + string));
        return true;
    }

    public void loadPlugins() {
        int n = pluginManager.numberOfUnloadedPlugins(new File(PaletteEditor.settings.pluginDirectoryName));
        int n2 = pluginManager.numberOfPlugins();
        String[] stringArray = new String[pluginManager.numberOfPlugins()];
        for (int i = 0; i < pluginManager.numberOfPlugins(); ++i) {
            stringArray[i] = pluginManager.getPlugin(i).getName();
        }
        console.writeLine("Number of unloaded plugins detected: " + n);
        if (n > 0) {
            final Task task = new Task(n, this.m_progressDialog);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    pluginManager.loadPlugins(new File(PaletteEditor.settings.pluginDirectoryName), task);
                }
            });
            thread.start();
            this.m_progressDialog.display("Loading", "Loading plugins...", 0, n);
            if (this.m_progressDialog.userCancelled() || !task.isCompleted()) {
                task.cancel();
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.m_progressDialog.clear();
            }
            paletteEditorWindow.update();
            if (pluginManager.numberOfPlugins() == 0 || pluginManager.numberOfPlugins() - n2 == 0) {
                console.writeLine("No plugins were loaded.");
            } else {
                int n3 = pluginManager.numberOfPlugins() - n2;
                boolean bl = true;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Successfully loaded " + n3 + " plugin" + (n3 == 1 ? "" : "s") + ": ");
                for (int i = 0; i < pluginManager.numberOfPlugins(); ++i) {
                    boolean bl2 = false;
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equalsIgnoreCase(pluginManager.getPlugin(i).getName())) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(pluginManager.getPlugin(i).getName());
                    bl = false;
                }
                console.writeLine(stringBuffer.toString());
            }
        } else {
            console.writeLine("No plugins to load.");
        }
    }

    public boolean createLogDirectory() {
        if (PaletteEditor.settings.logDirectoryName.length() == 0) {
            return true;
        }
        File file = new File(PaletteEditor.settings.logDirectoryName);
        if (!file.exists()) {
            try {
                return file.mkdirs();
            }
            catch (SecurityException securityException) {
                console.writeLine("Failed to create log directory, check read / write permissions.");
                return false;
            }
        }
        return true;
    }

    @Override
    public void notifyPaletteChanged(PalettePanel palettePanel) {
        paletteEditorWindow.update();
    }

    public void close() {
        this.m_initialized = false;
        if (PaletteEditor.settings.autoSaveSettings) {
            settings.save();
        }
    }

    static {
        currentPaletteNumber = 1;
    }
}

