/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.DataOutputStream;
import java.util.ArrayDeque;
import logger.Logger;
import server.Client;
import signal.LoginAuthenticatedSignal;
import signal.Signal;

public class ClientOutputSignalQueue
extends Thread {
    private ArrayDeque<Signal> m_outSignalQueue = new ArrayDeque();
    private DataOutputStream m_out;
    private Client m_client;
    private Logger m_logger;

    public void initialize(Client client, DataOutputStream out, Logger logger) {
        this.m_client = client;
        this.m_out = out;
        this.m_logger = logger;
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    public boolean isTerminated() {
        return this.getState() == Thread.State.TERMINATED;
    }

    public void addSignal(Signal s) {
        if (s == null) {
            return;
        }
        this.m_outSignalQueue.add(s);
    }

    @Override
    public void run() {
        while (this.m_client.isConnected()) {
            if (!this.m_outSignalQueue.isEmpty()) {
                Signal s = this.m_outSignalQueue.remove();
                if (s.getSignalType() == 1) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 2) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 4) {
                    s.writeTo(this.m_out);
                    LoginAuthenticatedSignal s2 = (LoginAuthenticatedSignal)s;
                    if (!s2.getAuthenticated()) {
                        this.m_client.disconnect();
                        this.m_logger.addInfo("Client #" + this.m_client.getClientNumber() + " disconnected: login rejected");
                    }
                } else if (s.getSignalType() == 6) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 7) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 11) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 13) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 15) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 17) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 18) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 19) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 20) {
                    s.writeTo(this.m_out);
                } else if (s.getSignalType() == 22) {
                    s.writeTo(this.m_out);
                    this.m_client.disconnect();
                    this.m_logger.addInfo("Client #" + this.m_client.getClientNumber() + " disconnected");
                } else if (s.getSignalType() == 23) {
                    s.writeTo(this.m_out);
                } else {
                    this.m_logger.addWarning("Unexpected output signal of type: " + s.getSignalType());
                }
            }
            try {
                ClientOutputSignalQueue.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

