/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import shared.StatusType;

public class UserPanel
extends JPanel
implements ActionListener {
    private JTextField personalMessageTextField;
    private JTextField nickNameTextField;
    private JLabel displayPicIconLabel;
    private JComboBox statusComboBox;
    private boolean m_editable = true;
    private static final long serialVersionUID = 1L;

    public UserPanel(boolean editable) {
        this.m_editable = editable;
        this.initComponents();
        this.initLayout();
        this.setEditable(this.m_editable);
    }

    public void setEditable(boolean editable) {
        this.nickNameTextField.setFocusable(this.m_editable);
        this.personalMessageTextField.setFocusable(this.m_editable);
        this.statusComboBox.setEnabled(this.m_editable);
    }

    private void initComponents() {
        this.displayPicIconLabel = new JLabel();
        this.nickNameTextField = new JTextField();
        this.personalMessageTextField = new JTextField();
        this.personalMessageTextField.setFont(new Font("Tahoma", 2, 11));
        this.displayPicIconLabel.setIcon(new ImageIcon("img/serious_logo.png"));
        this.statusComboBox = new JComboBox();
        this.statusComboBox.setModel(new DefaultComboBoxModel<String>(StatusType.statusTypes));
        this.statusComboBox.setToolTipText("Use this drop down box to select your status");
        this.statusComboBox.addActionListener(this);
    }

    private void initLayout() {
        GroupLayout contactPanelLayout = new GroupLayout(this);
        this.setLayout(contactPanelLayout);
        contactPanelLayout.setHorizontalGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contactPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.displayPicIconLabel).addGap(18, 18, 18).addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contactPanelLayout.createSequentialGroup().addComponent(this.nickNameTextField, -2, 260, -2).addGap(18, 18, 18).addComponent(this.statusComboBox, -1, 70, -2)).addComponent(this.personalMessageTextField, -1, 342, Short.MAX_VALUE)).addContainerGap()));
        contactPanelLayout.setVerticalGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contactPanelLayout.createSequentialGroup().addContainerGap().addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.displayPicIconLabel).addGroup(contactPanelLayout.createSequentialGroup().addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nickNameTextField, -2, -1, -2).addComponent(this.statusComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.personalMessageTextField, -2, -1, -2))).addContainerGap()));
    }

    public static ImageIcon getDisplayPicture(String userName) {
        if (userName == null) {
            return new ImageIcon("img/serious_logo.png");
        }
        String filePath = "img/" + userName + ".png";
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return new ImageIcon("img/serious_logo.png");
        }
        return new ImageIcon(filePath);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        e.getSource();
    }
}

