/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class ContactBlockedSignal
extends Signal {
    private String m_userName;
    private boolean m_blocked;
    private boolean m_succeeded;
    public static final int LENGTH = 74;

    private ContactBlockedSignal() {
        super(17);
    }

    public ContactBlockedSignal(String userName, boolean blocked, boolean succeeded) {
        super(17);
        this.m_userName = userName;
        this.m_blocked = blocked;
        this.m_succeeded = succeeded;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public boolean getBlocked() {
        return this.m_blocked;
    }

    public boolean getSucceeded() {
        return this.m_succeeded;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        checksum += ByteStream.getChecksum(this.m_blocked);
        return checksum += ByteStream.getChecksum(this.m_succeeded);
    }

    public static ContactBlockedSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ContactBlockedSignal s2 = new ContactBlockedSignal();
        s2.m_userName = byteStream.nextString(32);
        s2.m_blocked = byteStream.nextBoolean();
        s2.m_succeeded = byteStream.nextBoolean();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addBoolean(this.m_blocked);
        byteStream.addBoolean(this.m_succeeded);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ContactBlockedSignal.readFrom(byteStream);
    }
}

