/*
 * Decompiled with CFR 0.152.
 */
package signal;

import shared.ByteStream;
import signal.Signal;

public class ContactDeletedSignal
extends Signal {
    private String m_userName;
    private boolean m_deleted;
    public static final int LENGTH = 73;

    private ContactDeletedSignal() {
        super(15);
    }

    public ContactDeletedSignal(String userName, boolean deleted) {
        super(15);
        this.m_userName = userName;
        this.m_deleted = deleted;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public boolean getDeleted() {
        return this.m_deleted;
    }

    @Override
    public long checksum() {
        long checksum = 0L;
        checksum += ByteStream.getChecksum(this.m_userName, 32);
        return checksum += ByteStream.getChecksum(this.m_deleted);
    }

    public static ContactDeletedSignal readFrom(ByteStream byteStream) {
        if (byteStream == null) {
            return null;
        }
        ContactDeletedSignal s2 = new ContactDeletedSignal();
        s2.m_userName = byteStream.nextString(32);
        s2.m_deleted = byteStream.nextBoolean();
        long checksum = byteStream.nextLong();
        if (checksum != s2.checksum()) {
            return null;
        }
        return s2;
    }

    @Override
    public void writeTo(ByteStream byteStream) {
        if (byteStream == null) {
            return;
        }
        super.writeTo(byteStream);
        byteStream.addStringFixedLength(this.m_userName, 32);
        byteStream.addBoolean(this.m_deleted);
        byteStream.addLong(this.checksum());
    }

    public static /* bridge */ /* synthetic */ Signal readFrom(ByteStream byteStream) {
        return ContactDeletedSignal.readFrom(byteStream);
    }
}

