/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import server.SystemManager;
import shared.SignalDebugLevel;
import shared.Updatable;

public class ServerWindow
extends JFrame
implements ActionListener,
WindowListener,
Updatable {
    private JTextArea m_consoleText;
    private Font m_consoleFont;
    private JScrollPane m_consoleScrollPane;
    private boolean m_updating;
    private JMenuBar m_menuBar;
    private JMenu m_fileMenu;
    private JMenuItem m_fileExitMenuItem;
    private JMenu m_settingsMenu;
    private JCheckBoxMenuItem m_settingsAutoScrollConsoleWindowMenuItem;
    private JMenuItem m_settingsMaxConsoleHistoryMenuItem;
    private JMenu m_settingsSignalsMenu;
    private JCheckBoxMenuItem m_settingsSignalsIgnorePingPongMenuItem;
    private JCheckBoxMenuItem m_settingsSignalsIgnorePositionMenuItem;
    private JRadioButtonMenuItem[] m_settingsSignalsMenuItem;
    private ButtonGroup m_settingsSignalsButtonGroup;
    private JCheckBoxMenuItem m_settingsAutoSaveOnExitMenuItem;
    private JMenuItem m_settingsSaveMenuItem;
    private JMenuItem m_settingsResetMenuItem;
    private JMenu m_helpMenu;
    private JMenuItem helpAboutMenuItem;
    private static final long serialVersionUID = 1L;

    public ServerWindow() {
        this.setTitle("Server Window");
        this.setMinimumSize(new Dimension(320, 240));
        this.setDefaultCloseOperation(3);
        this.addWindowListener(this);
        SystemManager.console.setTarget(this);
        this.m_updating = false;
        this.initMenu();
        this.initComponents();
    }

    public void initialize() {
        this.update();
        this.setVisible(true);
    }

    private void initMenu() {
        this.m_menuBar = new JMenuBar();
        this.m_fileMenu = new JMenu("File");
        this.m_fileExitMenuItem = new JMenuItem("Exit");
        this.m_settingsMenu = new JMenu("Settings");
        this.m_settingsAutoScrollConsoleWindowMenuItem = new JCheckBoxMenuItem("Auto-scroll Console Window");
        this.m_settingsSignalsMenu = new JMenu("Signal Debugging");
        this.m_settingsSignalsIgnorePingPongMenuItem = new JCheckBoxMenuItem("Ignore Ping Pong Signals");
        this.m_settingsSignalsIgnorePositionMenuItem = new JCheckBoxMenuItem("Ignore Position Signals");
        this.m_settingsSignalsMenuItem = new JRadioButtonMenuItem[SignalDebugLevel.signalDebugLevels.length];
        int i = 0;
        while (i < SignalDebugLevel.signalDebugLevels.length) {
            this.m_settingsSignalsMenuItem[i] = new JRadioButtonMenuItem(SignalDebugLevel.signalDebugLevels[i]);
            i = (byte)(i + 1);
        }
        this.m_settingsAutoSaveOnExitMenuItem = new JCheckBoxMenuItem("Autosave on Exit");
        this.m_settingsSaveMenuItem = new JMenuItem("Save Settings");
        this.m_settingsResetMenuItem = new JMenuItem("Reset Settings");
        this.m_helpMenu = new JMenu("Help");
        this.helpAboutMenuItem = new JMenuItem("About");
        this.m_settingsAutoSaveOnExitMenuItem.setSelected(true);
        this.m_settingsAutoScrollConsoleWindowMenuItem.setSelected(true);
        this.m_settingsMaxConsoleHistoryMenuItem = new JMenuItem("Max Console History");
        this.m_settingsSignalsIgnorePingPongMenuItem.setSelected(true);
        this.m_settingsSignalsIgnorePositionMenuItem.setSelected(true);
        this.m_settingsSignalsMenuItem[3].setSelected(true);
        this.m_settingsSignalsButtonGroup = new ButtonGroup();
        this.m_fileExitMenuItem.addActionListener(this);
        this.m_settingsAutoScrollConsoleWindowMenuItem.addActionListener(this);
        this.m_settingsMaxConsoleHistoryMenuItem.addActionListener(this);
        this.m_settingsSignalsIgnorePingPongMenuItem.addActionListener(this);
        this.m_settingsSignalsIgnorePositionMenuItem.addActionListener(this);
        i = 0;
        while (i < SignalDebugLevel.signalDebugLevels.length) {
            this.m_settingsSignalsMenuItem[i].addActionListener(this);
            i = (byte)(i + 1);
        }
        this.m_settingsAutoSaveOnExitMenuItem.addActionListener(this);
        this.m_settingsSaveMenuItem.addActionListener(this);
        this.m_settingsResetMenuItem.addActionListener(this);
        this.helpAboutMenuItem.addActionListener(this);
        i = 0;
        while (i < SignalDebugLevel.signalDebugLevels.length) {
            this.m_settingsSignalsButtonGroup.add(this.m_settingsSignalsMenuItem[i]);
            i = (byte)(i + 1);
        }
        this.m_fileMenu.add(this.m_fileExitMenuItem);
        this.m_settingsMenu.add(this.m_settingsAutoScrollConsoleWindowMenuItem);
        this.m_settingsMenu.add(this.m_settingsMaxConsoleHistoryMenuItem);
        this.m_settingsSignalsMenu.add(this.m_settingsSignalsIgnorePingPongMenuItem);
        this.m_settingsSignalsMenu.add(this.m_settingsSignalsIgnorePositionMenuItem);
        i = 0;
        while (i < SignalDebugLevel.signalDebugLevels.length) {
            this.m_settingsSignalsMenu.add(this.m_settingsSignalsMenuItem[i]);
            i = (byte)(i + 1);
        }
        this.m_settingsMenu.add(this.m_settingsSignalsMenu);
        this.m_settingsMenu.add(this.m_settingsAutoSaveOnExitMenuItem);
        this.m_settingsMenu.add(this.m_settingsSaveMenuItem);
        this.m_settingsMenu.add(this.m_settingsResetMenuItem);
        this.m_helpMenu.add(this.helpAboutMenuItem);
        this.m_menuBar.add(this.m_fileMenu);
        this.m_menuBar.add(this.m_settingsMenu);
        this.m_menuBar.add(this.m_helpMenu);
        this.setJMenuBar(this.m_menuBar);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Master Server");
        this.setCursor(new Cursor(0));
        this.setMinimumSize(new Dimension(640, 480));
        this.setName("ServerWindow");
        this.m_consoleText = new JTextArea();
        this.m_consoleFont = new Font("Verdana", 0, 14);
        this.m_consoleText.setFont(this.m_consoleFont);
        this.m_consoleText.setEditable(false);
        this.m_consoleScrollPane = new JScrollPane(this.m_consoleText);
        this.add(this.m_consoleScrollPane);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (SystemManager.settings.getAutoSaveOnExit()) {
            SystemManager.save();
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_updating) {
            return;
        }
        if (e.getSource() == this.m_fileExitMenuItem) {
            System.exit(0);
        } else if (e.getSource() == this.m_settingsAutoScrollConsoleWindowMenuItem) {
            SystemManager.settings.setAutoScrollConsoleWindow(this.m_settingsAutoScrollConsoleWindowMenuItem.isSelected());
        } else if (e.getSource() == this.m_settingsMaxConsoleHistoryMenuItem) {
            String input = JOptionPane.showInputDialog(this, "Please enter the maximum console history size:", SystemManager.settings.getMaxConsoleHistory());
            if (input == null) {
                return;
            }
            int maxConsoleHistory = -1;
            try {
                maxConsoleHistory = Integer.parseInt(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            SystemManager.settings.setMaxConsoleHistory(maxConsoleHistory);
        } else if (e.getSource() == this.m_settingsSignalsIgnorePingPongMenuItem) {
            SystemManager.settings.setIgnorePingPongSignals(this.m_settingsSignalsIgnorePingPongMenuItem.isSelected());
        } else if (e.getSource() == this.m_settingsSignalsIgnorePositionMenuItem) {
            SystemManager.settings.setIgnorePositionSignals(this.m_settingsSignalsIgnorePositionMenuItem.isSelected());
        } else if (e.getSource() == this.m_settingsAutoSaveOnExitMenuItem) {
            SystemManager.settings.setAutoSaveOnExit(this.m_settingsAutoSaveOnExitMenuItem.isSelected());
        } else if (e.getSource() == this.m_settingsSaveMenuItem) {
            SystemManager.settings.save();
        } else if (e.getSource() == this.m_settingsResetMenuItem) {
            SystemManager.settings.reset();
        } else if (e.getSource() == this.helpAboutMenuItem) {
            JOptionPane.showMessageDialog(this, "MasterServer Created by Kevin Scroggins (nitro404@hotmail.com).\nCreated for the COMP 4807 Final Project - April 4, 2011.", "About MasterServer", 1);
        } else {
            byte i = 0;
            while (i < SignalDebugLevel.signalDebugLevels.length) {
                if (e.getSource() == this.m_settingsSignalsMenuItem[i]) {
                    SystemManager.settings.setSignalDebugLevel(i);
                }
                i = (byte)(i + 1);
            }
        }
    }

    @Override
    public void update() {
        this.m_updating = true;
        this.m_settingsSignalsIgnorePingPongMenuItem.setSelected(SystemManager.settings.getIgnorePingPongSignals());
        this.m_settingsSignalsIgnorePositionMenuItem.setSelected(SystemManager.settings.getIgnorePositionSignals());
        this.m_settingsSignalsMenuItem[SystemManager.settings.getSignalDebugLevel()].setSelected(true);
        this.m_settingsAutoScrollConsoleWindowMenuItem.setSelected(SystemManager.settings.getAutoScrollConsoleWindow());
        try {
            this.m_consoleText.setText(SystemManager.console.toString());
            if (SystemManager.settings.getAutoScrollConsoleWindow()) {
                this.m_consoleText.setCaretPosition(this.m_consoleText.getText().length());
                this.m_consoleText.scrollRectToVisible(new Rectangle(0, this.m_consoleText.getHeight() - 2, 1, 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_updating = false;
    }
}

