/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import settings.Variable;

public class VariableSystem {
    private Vector<Variable> m_variables = new Vector();
    private Vector<String> m_categories = new Vector();

    public int addCategory(String category) {
        if (category == null) {
            return -1;
        }
        String temp = category.trim();
        if (category.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < this.m_categories.size()) {
            if (temp.equalsIgnoreCase(this.m_categories.elementAt(i))) {
                return i;
            }
            ++i;
        }
        this.m_categories.add(temp);
        return this.m_categories.size() - 1;
    }

    public int indexOfCategory(String category) {
        if (category == null || this.m_categories.size() == 0) {
            return -1;
        }
        String temp = category.trim();
        int i = 0;
        while (i < this.m_categories.size()) {
            if (temp.equalsIgnoreCase(this.m_categories.elementAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String categoryAt(int index) {
        if (index < 0 || index >= this.m_categories.size()) {
            return null;
        }
        return this.m_categories.elementAt(index);
    }

    public int size() {
        return this.m_variables.size();
    }

    public boolean contains(String id) {
        if (id == null) {
            return false;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(String id, String category) {
        if (id == null || category == null) {
            return false;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return false;
        }
        int categoryIndex = this.indexOfCategory(category);
        int i = 0;
        while (i < this.m_variables.size()) {
            if (categoryIndex == this.m_variables.elementAt(i).getCategory() && this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Variable v) {
        if (v == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getCategory() == v.getCategory() && this.m_variables.elementAt(i).getID().equalsIgnoreCase(v.getID())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(String id) {
        if (id == null) {
            return -1;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String id, String category) {
        if (id == null) {
            return -1;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return -1;
        }
        int categoryIndex = this.indexOfCategory(category);
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getCategory() == categoryIndex && this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(Variable v) {
        if (v == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getCategory() == v.getCategory() && this.m_variables.elementAt(i).getID().equalsIgnoreCase(v.getID())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Variable elementAt(int index) {
        if (index < 0 || index >= this.m_variables.size()) {
            return null;
        }
        return this.m_variables.elementAt(index);
    }

    public Variable getVariable(String id) {
        if (id == null) {
            return null;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                return this.m_variables.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public Variable getVariable(String id, String category) {
        if (id == null) {
            return null;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return null;
        }
        int categoryIndex = this.indexOfCategory(category);
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getCategory() == categoryIndex && this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                return this.m_variables.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public String getValue(String id) {
        if (id == null) {
            return null;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                return this.m_variables.elementAt(i).getValue();
            }
            ++i;
        }
        return null;
    }

    public String getValue(String id, String category) {
        if (id == null) {
            return null;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return null;
        }
        int categoryIndex = this.indexOfCategory(category);
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getCategory() == categoryIndex && this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                return this.m_variables.elementAt(i).getValue();
            }
            ++i;
        }
        return null;
    }

    public Vector<Variable> getVariablesInCategory(String category) {
        if (category == null) {
            return null;
        }
        int categoryIndex = this.indexOfCategory(category);
        Vector<Variable> variableCollection = new Vector<Variable>();
        int i = 0;
        while (i < this.m_variables.size()) {
            if (categoryIndex == this.m_variables.elementAt(i).getCategory()) {
                variableCollection.add(this.m_variables.elementAt(i));
            }
            ++i;
        }
        return variableCollection;
    }

    public boolean add(String id, String value) {
        if (id == null || value == null) {
            return false;
        }
        if (!this.contains(id, "")) {
            this.m_variables.add(new Variable(id, value, -1));
            return true;
        }
        return false;
    }

    public boolean add(String id, String value, String category) {
        if (id == null || value == null || category == null) {
            return false;
        }
        if (!this.contains(id, category)) {
            int categoryIndex = this.addCategory(category);
            this.m_variables.add(new Variable(id, value, categoryIndex));
            return true;
        }
        return false;
    }

    public boolean add(Variable v) {
        if (v == null || v.getID().length() == 0) {
            return false;
        }
        if (!this.contains(v) && v.getCategory() < this.m_categories.size()) {
            this.m_variables.add(v);
            return true;
        }
        return false;
    }

    public void add(Variable[] v) {
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.length) {
            this.add(v[i]);
            ++i;
        }
    }

    public void add(Vector<Variable> v) {
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.size()) {
            this.add(v.elementAt(i));
            ++i;
        }
    }

    public void add(VariableSystem v) {
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.m_variables.size()) {
            this.add(v.m_variables.elementAt(i));
            ++i;
        }
    }

    public void setValue(String id, String value) {
        if (id == null || value == null) {
            return;
        }
        String temp = id.trim();
        if (id.length() == 0) {
            return;
        }
        boolean valueUpdated = false;
        int i = 0;
        while (i < this.m_variables.size()) {
            if (temp.equalsIgnoreCase(this.m_variables.elementAt(i).getID())) {
                this.m_variables.elementAt(i).setValue(value);
                valueUpdated = true;
            }
            ++i;
        }
        if (!valueUpdated) {
            this.add(id, value);
        }
    }

    public void setValue(String id, int value) {
        this.setValue(id, Integer.toString(value));
    }

    public void setValue(String id, double value) {
        this.setValue(id, Double.toString(value));
    }

    public void setValue(String id, boolean value) {
        this.setValue(id, value ? "true" : "false");
    }

    public void setValue(String id, String value, String category) {
        if (id == null || category == null) {
            return;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return;
        }
        int categoryIndex = this.indexOfCategory(category);
        boolean valueUpdated = false;
        int i = 0;
        while (i < this.m_variables.size()) {
            if (categoryIndex == this.m_variables.elementAt(i).getCategory() && temp.equalsIgnoreCase(this.m_variables.elementAt(i).getID())) {
                this.m_variables.elementAt(i).setValue(value);
                valueUpdated = true;
            }
            ++i;
        }
        if (!valueUpdated) {
            this.add(id, value, category);
        }
    }

    public void setValue(String id, int value, String category) {
        this.setValue(id, Integer.toString(value), category);
    }

    public void setValue(String id, double value, String category) {
        this.setValue(id, Double.toString(value), category);
    }

    public void setValue(String id, boolean value, String category) {
        this.setValue(id, value ? "true" : "false", category);
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.m_variables.size()) {
            return false;
        }
        this.m_variables.remove(index);
        return true;
    }

    public boolean remove(String id) {
        if (id == null) {
            return false;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                this.m_variables.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean remove(String id, String category) {
        if (id == null) {
            return false;
        }
        String temp = id.trim();
        if (temp.length() == 0) {
            return false;
        }
        int categoryIndex = this.indexOfCategory(category);
        int i = 0;
        while (i < this.m_variables.size()) {
            if (categoryIndex == this.m_variables.elementAt(i).getCategory() && this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                this.m_variables.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean remove(Variable v) {
        if (v == null) {
            return false;
        }
        String temp = v.getID().trim();
        if (temp.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (v.getCategory() == this.m_variables.elementAt(i).getCategory() && this.m_variables.elementAt(i).getID().equalsIgnoreCase(temp)) {
                this.m_variables.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeCategory(String data) {
        if (data == null) {
            return;
        }
        String category = data.trim();
        int categoryIndex = this.indexOfCategory(category);
        int i = 0;
        while (i < this.m_variables.size()) {
            if (categoryIndex == this.m_variables.elementAt(i).getCategory()) {
                this.m_variables.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void clear() {
        this.m_variables.clear();
        this.m_categories.clear();
    }

    public void sort() {
        int i = 0;
        while (i < this.m_variables.size()) {
            int j = i;
            while (j < this.m_variables.size()) {
                if (this.m_variables.elementAt(i).getCategory() > this.m_variables.elementAt(j).getCategory()) {
                    Variable temp = this.m_variables.elementAt(i);
                    this.m_variables.set(i, this.m_variables.elementAt(j));
                    this.m_variables.set(j, temp);
                }
                ++j;
            }
            ++i;
        }
    }

    public static VariableSystem readFrom(String fileName) {
        if (fileName == null) {
            return null;
        }
        return VariableSystem.readFrom(new File(fileName));
    }

    public static VariableSystem readFrom(File file) {
        VariableSystem variables;
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        try {
            String input;
            BufferedReader in = new BufferedReader(new FileReader(file));
            variables = new VariableSystem();
            String category = null;
            int categoryIndex = -1;
            while ((input = in.readLine()) != null) {
                String data = input.trim();
                if (data.length() == 0) {
                    category = null;
                    categoryIndex = -1;
                    continue;
                }
                if (data.charAt(0) == '[' && data.charAt(data.length() - 1) == ']') {
                    category = data.substring(1, data.length() - 1).trim();
                    categoryIndex = variables.addCategory(category);
                    continue;
                }
                Variable v = Variable.parseFrom(data);
                if (v == null) continue;
                v.setCategory(categoryIndex);
                variables.add(v);
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return variables;
    }

    public boolean writeTo(String fileName) {
        return this.writeTo(new File(fileName));
    }

    public boolean writeTo(File file) {
        if (file == null) {
            return false;
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            this.writeTo(out);
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void writeTo(PrintWriter out) throws IOException {
        int lastCategory = -1;
        boolean firstLine = true;
        int i = 0;
        while (i < this.m_variables.size()) {
            if (lastCategory == -1 || lastCategory != this.m_variables.elementAt(i).getCategory()) {
                if (this.m_variables.elementAt(i).getCategory() != -1) {
                    if (!firstLine) {
                        out.println();
                    }
                    out.println("[" + this.m_categories.elementAt(this.m_variables.elementAt(i).getCategory()) + "]");
                    firstLine = false;
                }
                lastCategory = this.m_variables.elementAt(i).getCategory();
            }
            this.m_variables.elementAt(i).writeTo(out);
            firstLine = false;
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof VariableSystem)) {
            return false;
        }
        VariableSystem v = (VariableSystem)o;
        if (this.m_variables.size() != this.m_variables.size()) {
            return false;
        }
        int i = 0;
        while (i < this.m_variables.size()) {
            if (!v.contains(this.m_variables.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String s = new String();
        int i = 0;
        while (i < this.m_variables.size()) {
            s = String.valueOf(s) + this.m_variables.elementAt(i);
            if (i < this.m_variables.size() - 1) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
        }
        return s;
    }
}

