/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.Point;
import shared.Position;

public class RobotPosition {
    private Position m_position;
    private int m_angle;

    public RobotPosition(int x, int y, int angle) {
        this(new Position(x, y), angle);
    }

    public RobotPosition(Position position, int angle) {
        this.m_position = position == null ? new Position(-1, -1) : position;
        this.m_angle = angle;
    }

    public int getX() {
        return this.m_position.x;
    }

    public int getY() {
        return this.m_position.y;
    }

    public Point getPoint() {
        return this.m_position;
    }

    public int getAngleDegrees() {
        return this.m_angle;
    }

    public float getAngleRadians() {
        return (float)Math.toRadians(this.m_angle);
    }

    public void setX(int x) {
        this.m_position.x = x;
    }

    public void setY(int y) {
        this.m_position.y = y;
    }

    public void setPosition(Point p) {
        this.m_position = new Position(p.x, p.y);
    }

    public void setAngleDegrees(int angle) {
        this.m_angle = angle;
    }

    public void setAngleRadians(float angle) {
        this.m_angle = (int)Math.toDegrees(angle);
    }

    public static boolean isValid(RobotPosition robotPosition) {
        return robotPosition != null && robotPosition.isValid();
    }

    public boolean isValid() {
        return Position.isValid(this.m_position) && this.m_angle >= 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RobotPosition)) {
            return false;
        }
        RobotPosition p = (RobotPosition)o;
        return this.m_position.equals(p.m_position) && this.m_angle == p.m_angle;
    }

    public String toString() {
        return this.m_position + ", " + this.m_angle;
    }
}

